/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedPool<T> {
    private int capacity;
    private final ObjectFactory<T> factory;
    private Object[] storage;
    private int index = 0;

    public LimitedPool(int capacity, ObjectFactory<T> factory) {
        this.capacity = capacity;
        this.factory = factory;
        this.storage = new Object[10];
    }

    public T alloc() {
        if (this.index == 0) {
            return this.factory.create();
        }
        return (T)this.storage[--this.index];
    }

    public void recycle(T t) {
        this.factory.cleanup(t);
        if (this.index >= this.capacity) {
            return;
        }
        this.ensureCapacity();
        this.storage[this.index++] = t;
    }

    private void ensureCapacity() {
        if (this.storage.length <= this.index + 1) {
            int newCapacity = Math.min(this.capacity, this.storage.length * 3 / 2);
            Object[] newStorage = new Object[newCapacity];
            System.arraycopy(this.storage, 0, newStorage, 0, this.storage.length);
            this.storage = newStorage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectFactory<T> {
        public T create();

        public void cleanup(T var1);
    }
}

