/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.ObjectCacheBase;
import java.util.EventListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntObjectCache<T>
extends ObjectCacheBase
implements Iterable<T> {
    public static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    private int myTop;
    private int myBack;
    private CacheEntry<T>[] myCache;
    private int[] myHashTable;
    private int myHashTableSize;
    private int myCount;
    private int myFirstFree;
    private DeletedPairsListener[] myListeners;
    private int myAttempts;
    private int myHits;

    public IntObjectCache() {
        this(8192);
    }

    public IntObjectCache(int cacheSize) {
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (int i = 0; i < this.myCache.length; ++i) {
            this.myCache[i] = new CacheEntry();
        }
        this.myHashTableSize = IntObjectCache.getAdjustedTableSize(cacheSize);
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0;
        this.myHits = 0;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(int key) {
        return this.isCached(key);
    }

    public T get(int key) {
        return this.tryKey(key);
    }

    public T put(int key, T value) {
        T oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(int key) {
        int index = this.searchForCacheEntry(key);
        if (index != 0) {
            this.removeEntry(index);
            this.removeEntryFromHashTable(index);
            this.myCache[index].hash_next = this.myFirstFree;
            this.myFirstFree = index;
            CacheEntry<T> cacheEntry = this.myCache[index];
            int deletedKey = cacheEntry.key;
            Object deletedValue = cacheEntry.value;
            this.myCache[index].value = null;
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public void removeAll() {
        IntArrayList keys = new IntArrayList(this.count());
        int current = this.myTop;
        while (current > 0) {
            if (this.myCache[current].value != null) {
                keys.add(this.myCache[current].key);
            }
            current = this.myCache[current].next;
        }
        for (int i = 0; i < keys.size(); ++i) {
            this.remove(keys.get(i));
        }
    }

    public final void cacheObject(int key, T x) {
        int deletedKey = 0;
        Object deletedValue = null;
        int index = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index == 0) {
                index = this.myCount;
                ++index;
            } else {
                this.myFirstFree = this.myCache[index].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index;
            }
        } else {
            index = this.myBack;
            this.removeEntryFromHashTable(index);
            CacheEntry<T> cacheEntry = this.myCache[index];
            deletedKey = cacheEntry.key;
            deletedValue = cacheEntry.value;
            this.myBack = this.myCache[index].prev;
            this.myCache[this.myCache[index].prev].next = 0;
        }
        this.myCache[index].key = key;
        this.myCache[index].value = x;
        this.addEntry2HashTable(index);
        this.add2Top(index);
        if (deletedValue != null) {
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public final T tryKey(int key) {
        ++this.myAttempts;
        int index = this.searchForCacheEntry(key);
        if (index == 0) {
            return null;
        }
        ++this.myHits;
        CacheEntry<T> cacheEntry = this.myCache[index];
        int top = this.myTop;
        if (index != top) {
            int prev = cacheEntry.prev;
            int next = cacheEntry.next;
            if (index == this.myBack) {
                this.myBack = prev;
            } else {
                this.myCache[next].prev = prev;
            }
            this.myCache[prev].next = next;
            cacheEntry.next = top;
            cacheEntry.prev = 0;
            this.myCache[top].prev = index;
            this.myTop = index;
        }
        return cacheEntry.value;
    }

    public final boolean isCached(int key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public void resize(int newSize) {
        IntObjectCache newCache = new IntObjectCache(newSize);
        CacheEntry<T>[] cache = this.myCache;
        int back = this.myBack;
        while (back != 0) {
            CacheEntry<T> cacheEntry = cache[back];
            newCache.cacheObject(cacheEntry.key, cacheEntry.value);
            back = cacheEntry.prev;
        }
        this.myTop = newCache.myTop;
        this.myBack = newCache.myBack;
        this.myCache = newCache.myCache;
        this.myHashTable = newCache.myHashTable;
        this.myHashTableSize = newCache.myHashTableSize;
        this.myCount = newCache.myCount;
        this.myFirstFree = newCache.myFirstFree;
    }

    public double hitRate() {
        return this.myAttempts > 0 ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index) {
        this.myCache[index].next = this.myTop;
        this.myCache[index].prev = 0;
        this.myCache[this.myTop].prev = index;
        this.myTop = index;
    }

    private void removeEntry(int index) {
        if (index == this.myBack) {
            this.myBack = this.myCache[index].prev;
        } else {
            this.myCache[this.myCache[index].next].prev = this.myCache[index].prev;
        }
        if (index == this.myTop) {
            this.myTop = this.myCache[index].next;
        } else {
            this.myCache[this.myCache[index].prev].next = this.myCache[index].next;
        }
    }

    private void addEntry2HashTable(int index) {
        int hash_index = (this.myCache[index].key & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index) {
        int hash_index = (this.myCache[index].key & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[hash_index];
        int previous = 0;
        while (current != 0) {
            int next = this.myCache[current].hash_next;
            if (current == index) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next;
                } else {
                    this.myHashTable[hash_index] = next;
                }
                --this.myCount;
                break;
            }
            previous = current;
            current = next;
        }
    }

    private int searchForCacheEntry(int key) {
        this.myCache[0].key = key;
        int current = this.myHashTable[(key & Integer.MAX_VALUE) % this.myHashTableSize];
        while (true) {
            CacheEntry<T> cacheEntry = this.myCache[current];
            if (key == cacheEntry.key) break;
            current = cacheEntry.hash_next;
        }
        return current;
    }

    @Override
    public Iterator<T> iterator() {
        return new IntObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new DeletedPairsListener[1];
        } else {
            DeletedPairsListener[] newListeners = new DeletedPairsListener[this.myListeners.length + 1];
            System.arraycopy(this.myListeners, 0, newListeners, 0, this.myListeners.length);
            this.myListeners = newListeners;
        }
        this.myListeners[this.myListeners.length - 1] = listener;
    }

    public void removeDeletedPairsListener(DeletedPairsListener listener) {
        if (this.myListeners != null) {
            if (this.myListeners.length == 1) {
                this.myListeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.myListeners.length - 1];
                int i = 0;
                for (DeletedPairsListener myListener : this.myListeners) {
                    if (myListener == listener) continue;
                    newListeners[i++] = myListener;
                }
                this.myListeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(int key, Object value) {
        if (this.myListeners != null) {
            for (DeletedPairsListener myListener : this.myListeners) {
                myListener.objectRemoved(key, value);
            }
        }
    }

    public static interface DeletedPairsListener
    extends EventListener {
        public void objectRemoved(int var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IntObjectCacheIterator
    implements Iterator<T> {
        private int myCurrentEntry = 0;

        public IntObjectCacheIterator(IntObjectCache cache) {
            ((IntObjectCache)cache).myCache[0].next = cache.myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        @Override
        public T next() {
            return ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            IntObjectCache.this.removeEntry(((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheEntry<T> {
        public int key;
        public T value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }
}

