/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

public class HugeArray {
    private Object[][] myRows;
    private int myRowBits;
    private int myColumnMask;
    private int myMaxIndex = -1;

    public HugeArray(int rowBits) {
        this.myRowBits = rowBits;
        int rowLength = 1 << rowBits;
        this.myRows = new Object[rowLength][];
        this.myColumnMask = rowLength - 1;
    }

    public void put(int index, Object object) {
        int rowIndex = this.calcRow(index);
        Object[] row = this.myRows[rowIndex];
        if (row == null) {
            row = new Object[this.myColumnMask + 1];
            this.myRows[rowIndex] = row;
        }
        row[this.calcColumn((int)index)] = object;
        if (this.myMaxIndex < index) {
            this.myMaxIndex = index;
        }
    }

    public Object get(int index) {
        return this.myRows[this.calcRow(index)][this.calcColumn(index)];
    }

    public final int calcColumn(int index) {
        return index & this.myColumnMask;
    }

    public final int calcRow(int index) {
        return index >> this.myRowBits;
    }

    public int size() {
        return this.myMaxIndex + 1;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] array) {
        int firstIndex = 0;
        int rowLength = this.myColumnMask + 1;
        int lastRowToCopy = this.calcRow(array.length) + (this.calcColumn(array.length) == 0 ? 0 : 1);
        for (int rowIndex = 0; rowIndex < lastRowToCopy; ++rowIndex) {
            System.arraycopy(this.myRows[rowIndex], 0, array, firstIndex, Math.min(array.length - firstIndex, rowLength));
            firstIndex += rowLength;
        }
        return array;
    }

    public void add(Object object) {
        this.put(this.myMaxIndex + 1, object);
    }
}

