/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Convertor;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingIterator<Domain, Range>
implements Iterator<Range> {
    private final Iterator<Domain> myBaseIterator;
    private final Convertor<Domain, Range> myConvertor;

    public ConvertingIterator(Iterator<Domain> baseIterator, Convertor<Domain, Range> convertor) {
        this.myBaseIterator = baseIterator;
        this.myConvertor = convertor;
    }

    @Override
    public boolean hasNext() {
        return this.myBaseIterator.hasNext();
    }

    @Override
    public Range next() {
        return this.myConvertor.convert(this.myBaseIterator.next());
    }

    @Override
    public void remove() {
        this.myBaseIterator.remove();
    }

    public static <Domain, Intermediate, Range> Convertor<Domain, Range> composition(final Convertor<Domain, Intermediate> convertor1, final Convertor<Intermediate, Range> convertor2) {
        return new Convertor<Domain, Range>(){

            @Override
            public Range convert(Domain domain) {
                return convertor2.convert(convertor1.convert(domain));
            }
        };
    }

    public static <Domain, Range> ConvertingIterator<Domain, Range> create(Iterator<Domain> iterator, Convertor<Domain, Range> convertor) {
        return new ConvertingIterator<Domain, Range>(iterator, convertor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdConvertor<T>
    implements Convertor<T, T> {
        @Override
        public T convert(T object) {
            return object;
        }
    }
}

