/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtil {
    public static List<Object> mergeSortedLists(List<Object> list1, List<Object> list2, Comparator<Object> comparator, boolean mergeEqualItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            Object element2;
            if (index1 >= list1.size()) {
                result.add(list2.get(index2++));
                continue;
            }
            if (index2 >= list2.size()) {
                result.add(list1.get(index1++));
                continue;
            }
            Object element1 = list1.get(index1);
            int c = comparator.compare(element1, element2 = list2.get(index2));
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        return result;
    }

    public static <T> void addAll(Collection<T> collection, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> ArrayList<T> collect(Iterator<T> iterator) {
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        return list;
    }

    public static <T> HashSet<T> collectSet(Iterator<T> iterator) {
        HashSet hashSet = new HashSet();
        ContainerUtil.addAll(hashSet, iterator);
        return hashSet;
    }

    public static <K, V> HashMap<K, V> assignKeys(Iterator<V> iterator, Convertor<V, K> keyConvertor) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            hashMap.put(keyConvertor.convert(value), value);
        }
        return hashMap;
    }

    public static <K, V> HashMap<K, V> assignValues(Iterator<K> iterator, Convertor<K, V> valueConvertor) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            K key = iterator.next();
            hashMap.put(key, valueConvertor.convert(key));
        }
        return hashMap;
    }

    public static <T> Iterator<T> emptyIterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    public static <T> int findByEquals(T[] array, T element) {
        return ContainerUtil.findByEquals(Arrays.asList(array), element);
    }

    public static <T> int findByEquals(List<? extends T> list, T element) {
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            if (!(element == null ? t == null : element.equals(t))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static <T> T find(T[] array, Condition<T> condition) {
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(Iterable<? extends T> iterable, Processor<T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T[] iterable, Processor<? super T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V extends T> V find(Iterable<V> iterable, Condition<T> condition) {
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T> T find(Iterable<? extends T> iterable, final T equalTo) {
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(Iterator<V> iterator, Condition<T> condition) {
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    public static <T, V> List<V> map2List(T[] array, Function<T, V> mapper) {
        return ContainerUtil.map2List(Arrays.asList(array), mapper);
    }

    public static <T, V> List<V> map2List(Collection<? extends T> collection, Function<T, V> mapper) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    public static <T, V> Set<V> map2Set(T[] collection, Function<T, V> mapper) {
        return ContainerUtil.map2Set(Arrays.asList(collection), mapper);
    }

    public static <T, V> Set<V> map2Set(Collection<? extends T> collection, Function<T, V> mapper) {
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    public static <T> Object[] map2Array(T[] array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T> Object[] map2Array(Collection<T> array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T, V> V[] map2Array(T[] array, Class<? extends V> aClass, Function<T, V> mapper) {
        return ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, Class<? extends V> aClass, Function<T, V> mapper) {
        List<V> list = ContainerUtil.map2List(collection, mapper);
        return list.toArray((Object[])Array.newInstance(aClass, list.size()));
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, V[] to, Function<T, V> mapper) {
        return ContainerUtil.map2List(collection, mapper).toArray(to);
    }

    public static <T> List<T> findAll(T[] collection, Condition<? super T> condition) {
        return ContainerUtil.findAll(Arrays.asList(collection), condition);
    }

    public static <T> List<T> findAll(Collection<? extends T> collection, Condition<? super T> condition) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> skipNulls(Collection<? extends T> collection) {
        return ContainerUtil.findAll(collection, Condition.NOT_NULL);
    }

    public static <T, V> List<V> findAll(T[] collection, Class<V> instanceOf) {
        return ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
    }

    public static <T, V> List<V> findAll(Collection<? extends T> collection, Class<V> instanceOf) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> void removeDuplicates(Collection<T> collection) {
        HashSet<T> collected = new HashSet<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    public static <T> Iterator<T> iterate(T[] arrays) {
        return Arrays.asList(arrays).iterator();
    }

    public static <T> Iterator<T> iterate(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> void swapElements(List<E> list, int index1, int index2) {
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    public static <T> ArrayList<T> collect(Iterator<?> iterator, FilteringIterator.InstanceOf<T> instanceOf) {
        return ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
    }

    public static <T> void addAll(Collection<T> collection, Enumeration<T> enumeration) {
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    public static <T, U extends T> U findInstance(Iterable<T> iterable, Class<U> aClass) {
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(Iterator<T> iterator, Class<U> aClass) {
        return (U)ContainerUtil.find(iterator, new FilteringIterator.InstanceOf<U>(aClass));
    }

    @Nullable
    public static <T, U extends T> U findInstance(T[] array, Class<U> aClass) {
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    public static <T, V> List<T> concat(V[] array, Function<V, Collection<? extends T>> fun) {
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    public static <T> List<T> concat(Iterable<? extends Collection<T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> ts : list) {
            result.addAll(ts);
        }
        return result;
    }

    public static <T> List<T> concat(final @NotNull List<T> list1, final @NotNull List<T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < list1.size() ? list1.get(index) : list2.get(index - list1.size());
            }

            @Override
            public int size() {
                return list1.size() + list2.size();
            }
        };
    }

    public static <T, V> List<T> concat(Iterable<? extends V> list, Function<V, Collection<? extends T>> fun) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(fun.fun(v));
        }
        return result;
    }

    public static <T> boolean intersects(Collection<T> collection1, Collection<T> collection2) {
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getFirstItem(Collection<T> items, T def) {
        return items == null || items.isEmpty() ? def : items.iterator().next();
    }

    public static <T> Collection<T> subtract(Collection<T> from, Collection<T> what) {
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        return set;
    }

    public static <T> T[] toArray(List<T> collection, T[] array) {
        int length = array.length;
        if (length < 20) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            return array;
        }
        return collection.toArray(array);
    }

    public static <T, V> List<V> map(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        return result;
    }

    public static <T, V> List<V> mapNotNull(T[] array, Function<T, V> mapping) {
        return ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
    }

    public static <T, V> List<V> mapNotNull(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> packNullables(T ... elements) {
        ArrayList list = new ArrayList();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(element, list);
        }
        return list;
    }

    public static <T, V> List<V> map(T[] arr, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        return result;
    }

    public static <T, V> V[] map(T[] arr, Function<T, V> mapping, V[] emptyArray) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        return result.toArray(emptyArray);
    }

    public static <T> void addIfNotNull(T element, Collection<T> result) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void add(final T element, final Collection<T> result, Disposable parentDisposable) {
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        return element == null ? Collections.emptyList() : Arrays.asList(element);
    }

    public static <T, V> V getOrCreate(Map<T, V> result, T key, Factory<V> factory) {
        V list = result.get(key);
        if (list == null) {
            list = factory.create();
            result.put(key, list);
        }
        return list;
    }

    public static <T> boolean and(T[] iterable, Condition<T> condition) {
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    public static <T> boolean and(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean or(T[] iterable, Condition<T> condition) {
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean or(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<T, T> next) {
        if (next == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.unfold must not be null");
        }
        if (t == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        return list;
    }
}

