/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSoftArrayHashMap<T, V>
implements Cloneable {
    private ConcurrentSoftHashMap<T, ConcurrentSoftArrayHashMap<T, V>> myContinuationMap;
    private ConcurrentSoftHashMap<T, SoftReference<V>> myValuesMap;
    private SoftReference<V> myEmptyValue;
    private final TObjectHashingStrategy<T> myStrategy;

    public ConcurrentSoftArrayHashMap() {
        this(TObjectHashingStrategy.CANONICAL);
    }

    public ConcurrentSoftArrayHashMap(TObjectHashingStrategy<T> strategy) {
        this.myStrategy = strategy;
    }

    @Nullable
    private V get(T[] array, int index) {
        ConcurrentSoftArrayHashMap<T, V> map;
        if (index == array.length - 1) {
            SoftReference<V> softReference;
            ConcurrentSoftHashMap<T, SoftReference<V>> valuesMap = this.myValuesMap;
            if (valuesMap != null && (softReference = valuesMap.get(array[index])) != null) {
                return (V)softReference.get();
            }
            return null;
        }
        ConcurrentSoftHashMap<T, ConcurrentSoftArrayHashMap<T, V>> continuationMap = this.myContinuationMap;
        if (continuationMap != null && (map = continuationMap.get(array[index])) != null) {
            return super.get(array, index + 1);
        }
        return null;
    }

    @Nullable
    public final V get(T[] key) {
        if (key.length == 0) {
            SoftReference<V> emptyValue = this.myEmptyValue;
            return emptyValue == null ? null : (V)emptyValue.get();
        }
        return this.get(key, 0);
    }

    private void put(T[] array, int index, V value) {
        T key = array[index];
        if (index == array.length - 1) {
            if (this.myValuesMap == null) {
                this.myValuesMap = new ConcurrentSoftHashMap(this.myStrategy);
            }
            this.myValuesMap.put(key, new SoftReference<V>(value));
        } else {
            ConcurrentSoftArrayHashMap<T, V> softArrayHashMap;
            if (this.myContinuationMap == null) {
                this.myContinuationMap = new ConcurrentSoftHashMap(this.myStrategy);
            }
            if ((softArrayHashMap = this.myContinuationMap.get(key)) == null) {
                softArrayHashMap = new ConcurrentSoftArrayHashMap<T, V>(this.myStrategy);
                this.myContinuationMap.put(key, softArrayHashMap);
            }
            super.put(array, index + 1, value);
        }
    }

    public final synchronized void put(T[] key, V value) {
        if (key.length == 0) {
            this.myEmptyValue = new SoftReference<V>(value);
        } else {
            this.put(key, 0, value);
        }
    }

    public final synchronized void clear() {
        this.myContinuationMap = null;
        this.myValuesMap = null;
        this.myEmptyValue = null;
    }

    public final boolean containsKey(T[] path) {
        return this.get(path) != null;
    }

    public final synchronized ConcurrentSoftArrayHashMap<T, V> clone() {
        ConcurrentSoftArrayHashMap<T, V> copy = new ConcurrentSoftArrayHashMap<T, V>(this.myStrategy);
        copy.myContinuationMap = this.copyMap(this.myContinuationMap);
        copy.myValuesMap = this.copyMap(this.myValuesMap);
        copy.myEmptyValue = this.myEmptyValue;
        return copy;
    }

    private <X> ConcurrentSoftHashMap<T, X> copyMap(ConcurrentSoftHashMap<T, X> map) {
        ConcurrentSoftHashMap<T, X> copy = new ConcurrentSoftHashMap<T, X>();
        for (Map.Entry<T, X> entry : map.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

