/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentList<E>
extends AbstractList<E>
implements RandomAccess {
    private final Lock lock = new ReentrantLock();
    private volatile transient E[] elementData;
    private volatile int size;

    public ConcurrentList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public ConcurrentList() {
        this(10);
    }

    public ConcurrentList(Collection<? extends E> c) {
        this.size = c.size();
        int capacity = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.elementData = c.toArray(new Object[capacity]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        this.lock.lock();
        try {
            ++this.modCount;
            int oldCapacity = this.elementData.length;
            if (this.size < oldCapacity) {
                E[] oldData = this.elementData;
                this.elementData = new Object[this.size];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minCapacity) {
        this.lock.lock();
        try {
            ++this.modCount;
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                E[] oldData = this.elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Object[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ConcurrentList v = (ConcurrentList)super.clone();
            v.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.lock();
        try {
            this.RangeCheck(index);
            E oldValue = this.elementData[index];
            this.elementData[index] = element;
            E e = oldValue;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        this.lock.lock();
        try {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = o;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        this.lock.lock();
        try {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
            this.elementData[index] = element;
            ++this.size;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this.lock.lock();
        try {
            this.RangeCheck(index);
            ++this.modCount;
            E oldValue = this.elementData[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
            E e = oldValue;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            int index;
            if (o == null) {
                for (index = 0; index < this.size; ++index) {
                    if (this.elementData[index] != null) continue;
                    this.fastRemove(index);
                    boolean bl = true;
                    return bl;
                }
            } else {
                for (index = 0; index < this.size; ++index) {
                    if (!o.equals(this.elementData[index])) continue;
                    this.fastRemove(index);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            ++this.modCount;
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.lock();
        try {
            Object[] a = c.toArray();
            int numNew = a.length;
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(a, 0, this.elementData, this.size, numNew);
            this.size += numNew;
            boolean bl = numNew != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.lock();
        try {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            Object[] a = c.toArray();
            int numNew = a.length;
            this.ensureCapacity(this.size + numNew);
            int numMoved = this.size - index;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
            }
            System.arraycopy(a, 0, this.elementData, index, numNew);
            this.size += numNew;
            boolean bl = numNew != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.lock.lock();
        try {
            ++this.modCount;
            int numMoved = this.size - toIndex;
            System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
            int newSize = this.size - (toIndex - fromIndex);
            while (this.size != newSize) {
                this.elementData[--this.size] = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

