/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCachedValue<K, V> {
    private final Function<K, V> myValueFactory;
    private volatile V value;
    private volatile AtomicInteger state = new AtomicInteger(NOT_INITIALIZED);
    private static int NOT_INITIALIZED = 0;
    private static int BEING_BUILT = 1;
    private static int READY = 2;

    public ConcurrentCachedValue(final Computable<V> valueFactory) {
        this(new Function<K, V>(){

            @Override
            public V fun(K v) {
                return valueFactory.compute();
            }
        });
    }

    public ConcurrentCachedValue(Function<K, V> valueFactory) {
        this.myValueFactory = valueFactory;
    }

    public V getOrCache() {
        return this.getOrCache(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCache(K param) {
        while (true) {
            if (this.state.compareAndSet(NOT_INITIALIZED, BEING_BUILT)) {
                try {
                    this.value = this.myValueFactory.fun(param);
                }
                finally {
                    boolean updated = this.state.compareAndSet(BEING_BUILT, READY);
                    assert (updated);
                    assert (this.state.get() == READY);
                }
                continue;
            }
            if (this.state.get() != BEING_BUILT) break;
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(V value) {
        block9: {
            do {
                if (!this.state.compareAndSet(NOT_INITIALIZED, BEING_BUILT)) continue;
                try {
                    this.value = value;
                    break block9;
                }
                finally {
                    boolean updated = this.state.compareAndSet(BEING_BUILT, READY);
                    assert (updated);
                }
            } while (!this.state.compareAndSet(READY, BEING_BUILT));
            try {
                this.value = value;
            }
            finally {
                boolean updated = this.state.compareAndSet(BEING_BUILT, READY);
                assert (updated);
            }
        }
    }

    public void clear() {
        while (this.state.get() != NOT_INITIALIZED && !this.state.compareAndSet(READY, NOT_INITIALIZED)) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        AtomicInteger integer = new AtomicInteger(0);
        boolean ret = integer.compareAndSet(1, 2);
        System.out.println("ret = " + ret);
        System.out.println("integer.get() = " + integer.get());
        class S {
            ConcurrentCachedValue<Void, Map<String, String>> field = new ConcurrentCachedValue(new Computable<Map<String, String>>(){

                @Override
                public Map<String, String> compute() {
                    THashMap result = new THashMap();
                    for (int i = 0; i < 1000000; ++i) {
                        result.put("" + i % 1000, "" + i);
                    }
                    return result;
                }
            });

            S() {
            }

            String get(String key) {
                Map<String, String> cache = this.field.getOrCache();
                return cache.get(key);
            }
        }
        final S s = new S();
        for (int i = 0; i < 10; ++i) {
            final int index = i;
            new Thread(new Runnable(){
                {
                }

                public void run() {
                    s.get("" + index);
                }
            }, "My thread #" + i).start();
        }
    }
}

