/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoModifiableList<T>
extends AbstractList<T> {
    private ArrayList<T> myAfterIteratingElements = null;
    private final List<T> myElements;

    public CoModifiableList(List<T> elements) {
        this.myElements = elements;
    }

    @Override
    public synchronized boolean add(T rangeMarker) {
        if (this.myAfterIteratingElements != null) {
            this.myAfterIteratingElements.add(rangeMarker);
        } else {
            this.myElements.add(rangeMarker);
        }
        return true;
    }

    @Override
    public synchronized T remove(int index) {
        return this.myElements.remove(index);
    }

    @Override
    public T get(int index) {
        return this.myElements.get(index);
    }

    @Override
    public int size() {
        return this.myElements.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(InnerIterator<T> innerIterator) {
        if (this.myAfterIteratingElements != null) {
            throw new RuntimeException("Nested iterations aren't supported");
        }
        try {
            this.myAfterIteratingElements = new ArrayList();
            Iterator<T> iterator = this.myElements.iterator();
            while (iterator.hasNext()) {
                T rangeMarker = iterator.next();
                if (rangeMarker == null) continue;
                innerIterator.process(rangeMarker, iterator);
            }
        }
        finally {
            CoModifiableList coModifiableList = this;
            synchronized (coModifiableList) {
                for (T rangeMarker : this.myAfterIteratingElements) {
                    this.myElements.add(rangeMarker);
                }
                this.myAfterIteratingElements = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InnerIterator<T> {
        public void process(T var1, Iterator<T> var2);
    }
}

