/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalMap<K, V>
implements Map<K, V> {
    private Map<K, V> myKeyToValueMap = new THashMap();
    private Map<V, List<K>> myValueToKeysMap = new THashMap();

    @Override
    public V put(K key, V value) {
        List<K> array;
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
        }
        if ((array = this.myValueToKeysMap.get(value)) == null) {
            array = new ArrayList<K>();
            this.myValueToKeysMap.put((List<K>)value, (List<V>)array);
        }
        array.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    public boolean contaisValue(V value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public Set<K> keySet() {
        return this.myKeyToValueMap.keySet();
    }

    @Override
    public int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    @Override
    public V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        Set<K> ks = t.keySet();
        for (K k : ks) {
            this.put(k, t.get(k));
        }
    }

    @Override
    public Collection<V> values() {
        return this.myValueToKeysMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.myKeyToValueMap.entrySet();
    }
}

