/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageProperty
extends AbstractProperty<Storage> {
    private final String myName;

    public StorageProperty(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public Storage getDefault(AbstractProperty.AbstractPropertyContainer container) {
        Storage.MapStorage storage = new Storage.MapStorage();
        this.set(container, storage);
        return storage;
    }

    @Override
    public Storage copy(Storage storage) {
        if (!(storage instanceof Storage.MapStorage)) {
            throw new UnsupportedOperationException(storage.getClass().getName());
        }
        Iterator<String> keys = ((Storage.MapStorage)storage).getKeys();
        Storage.MapStorage copy = new Storage.MapStorage();
        while (keys.hasNext()) {
            String key = keys.next();
            copy.put(key, storage.get(key));
        }
        return copy;
    }

    @Override
    public String getName() {
        return this.myName;
    }
}

