/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.IntProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StorageProperty;
import com.intellij.util.config.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalizablePropertyContainer
extends AbstractProperty.AbstractPropertyContainer
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.config.ExternalizablePropertyContainer");
    private final Map<AbstractProperty, Object> myValues = new HashMap<AbstractProperty, Object>();
    private final Map<AbstractProperty, Externalizer> myExternalizers = new HashMap<AbstractProperty, Externalizer>();

    public <T> void registerProperty(AbstractProperty<T> property, Externalizer<T> externalizer) {
        String name = property.getName();
        LOG.assertTrue(!this.myExternalizers.containsKey(property), name);
        this.myExternalizers.put(property, externalizer);
    }

    public void rememberKey(AbstractProperty property) {
        LOG.assertTrue(this.myExternalizers.get(property) == null, property.getName());
        this.myExternalizers.put(property, null);
    }

    public void registerProperty(BooleanProperty property) {
        this.registerProperty(property, Externalizer.BOOLEAN);
    }

    public void registerProperty(StringProperty property) {
        this.registerProperty(property, Externalizer.STRING);
    }

    public void registerProperty(IntProperty property) {
        this.registerProperty(property, Externalizer.INTEGER);
    }

    public void registerProperty(StorageProperty property) {
        this.registerProperty(property, Externalizer.STORAGE);
    }

    public <T> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Externalizer<T> itemExternalizer) {
        this.registerProperty(property, this.createListExternalizer(itemExternalizer, itemTagName));
    }

    public <T extends JDOMExternalizable> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Factory<T> factory) {
        this.registerProperty(property, itemTagName, Externalizer.FactoryBased.create(factory));
    }

    private <T> Externalizer<List<T>> createListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
        return new ListExternalizer<T>(itemExternalizer, itemTagName);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        HashMap<String, AbstractProperty> propertyByName = new HashMap<String, AbstractProperty>();
        for (AbstractProperty abstractProperty : this.myExternalizers.keySet()) {
            propertyByName.put(abstractProperty.getName(), abstractProperty);
        }
        List children = element.getChildren();
        for (Element child : children) {
            Externalizer externalizer;
            AbstractProperty property = (AbstractProperty)propertyByName.get(child.getName());
            if (property == null || (externalizer = this.myExternalizers.get(property)) == null) continue;
            this.myValues.put(property, externalizer.readValue(child));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>(this.myExternalizers.keySet());
        Collections.sort(properties, AbstractProperty.NAME_COMPARATOR);
        for (AbstractProperty property : properties) {
            Externalizer externalizer = this.myExternalizers.get(property);
            if (externalizer == null) continue;
            Element child = new Element(property.getName());
            externalizer.writeValue(child, this.getValueOf(property));
            element.addContent(child);
        }
    }

    protected Object getValueOf(AbstractProperty property) {
        Object value = this.myValues.get(property);
        return value != null ? value : property.getDefault(this);
    }

    protected void setValueOf(AbstractProperty externalizableProperty, Object value) {
        this.myValues.put(externalizableProperty, value);
    }

    @Override
    public boolean hasProperty(AbstractProperty property) {
        return this.myExternalizers.containsKey(property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListExternalizer<T>
    implements Externalizer<List<T>> {
        @NonNls
        private static final String NULL_ELEMENT = "NULL_VALUE_ELEMENT";
        private final Externalizer<T> myItemExternalizer;
        private final String myItemTagName;

        public ListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
            this.myItemExternalizer = itemExternalizer;
            this.myItemTagName = itemTagName;
        }

        @Override
        public List<T> readValue(Element dataElement) throws InvalidDataException {
            ArrayList<T> list = new ArrayList<T>();
            List children = dataElement.getChildren();
            for (Element element : children) {
                if (NULL_ELEMENT.equals(element.getName())) {
                    list.add(null);
                    continue;
                }
                if (!this.myItemTagName.equals(element.getName())) continue;
                T item = this.myItemExternalizer.readValue(element);
                if (item == null) {
                    LOG.error("Can't create element " + this.myItemExternalizer);
                    return list;
                }
                list.add(item);
            }
            return list;
        }

        @Override
        public void writeValue(Element dataElement, List<T> value) throws WriteExternalException {
            for (T item : value) {
                if (item != null) {
                    Element element = new Element(this.myItemTagName);
                    this.myItemExternalizer.writeValue(element, item);
                    dataElement.addContent(element);
                    continue;
                }
                dataElement.addContent(new Element(NULL_ELEMENT));
            }
        }
    }
}

