/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;

public class Semaphore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.concurrency.Semaphore");
    private int mySemaphore = 0;

    public synchronized void down() {
        ++this.mySemaphore;
    }

    public synchronized void up() {
        --this.mySemaphore;
        if (this.mySemaphore == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitFor() {
        try {
            while (this.mySemaphore > 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOG.debug(e);
            throw new RuntimeException(e);
        }
    }

    public synchronized void waitFor(long timeout) {
        try {
            long startTime = System.currentTimeMillis();
            long waitTime = timeout;
            while (this.mySemaphore > 0) {
                this.wait(waitTime);
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed < timeout) {
                    waitTime = timeout - elapsed;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.debug(e);
            throw new RuntimeException(e);
        }
    }
}

