/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.WriterPreferenceReadWriteLock;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;

public class ReentrantWriterPreferenceReadWriteLock
extends WriterPreferenceReadWriteLock {
    protected long writeHolds_ = 0L;
    protected ThreadToCountMap readers_ = new ThreadToCountMap();

    public synchronized boolean isReadLockAcquired(Thread thread) {
        return this.readers_.get(thread) > 0;
    }

    public synchronized boolean isWriteLockAcquired(Thread thread) {
        return this.activeWriter_ == thread;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0L || this.activeWriter_ == Thread.currentThread();
    }

    protected synchronized boolean startRead() {
        Thread t = Thread.currentThread();
        int c = this.readers_.get(t);
        if (c > 0) {
            this.readers_.put(t, c + 1);
            ++this.activeReaders_;
            return true;
        }
        if (this.allowReader()) {
            this.readers_.put(t, 1);
            ++this.activeReaders_;
            return true;
        }
        return false;
    }

    protected synchronized boolean startWrite() {
        if (this.activeWriter_ == Thread.currentThread()) {
            ++this.writeHolds_;
            return true;
        }
        if (this.writeHolds_ == 0L) {
            if (this.activeReaders_ == 0L || this.readers_.size() == 1 && this.readers_.get(Thread.currentThread()) > 0) {
                this.activeWriter_ = Thread.currentThread();
                this.writeHolds_ = 1L;
                return true;
            }
            return false;
        }
        return false;
    }

    protected synchronized WriterPreferenceReadWriteLock.Signaller endRead() {
        --this.activeReaders_;
        Thread t = Thread.currentThread();
        int c = this.readers_.get(t);
        if (c != 1) {
            this.readers_.put(t, c - 1);
            return null;
        }
        this.readers_.put(t, 0);
        if (this.writeHolds_ > 0L) {
            return null;
        }
        if (this.activeReaders_ <= 1L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized WriterPreferenceReadWriteLock.Signaller endWrite() {
        --this.writeHolds_;
        if (this.writeHolds_ > 0L) {
            return null;
        }
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    private static final class ThreadToCountMap {
        private ArrayList<Thread> myThreads = new ArrayList();
        private TIntArrayList myCounters = new TIntArrayList();
        private Thread myLastThread = null;
        private int myLastCounter;

        private ThreadToCountMap() {
        }

        public int get(Thread thread) {
            if (thread == this.myLastThread) {
                return this.myLastCounter;
            }
            int index = this.myThreads.indexOf(thread);
            int result = index >= 0 ? this.myCounters.getQuick(index) : 0;
            this.myLastThread = thread;
            this.myLastCounter = result;
            return result;
        }

        public void put(Thread thread, int count) {
            this.myLastThread = null;
            int index = this.myThreads.indexOf(thread);
            if (index >= 0) {
                if (count == 0) {
                    this.myThreads.remove(index);
                    this.myCounters.remove(index);
                } else {
                    this.myCounters.setQuick(index, count);
                }
            } else if (count != 0) {
                this.myThreads.add(thread);
                this.myCounters.add(count);
            }
        }

        public int size() {
            return this.myThreads.size();
        }
    }
}

