/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Ref;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueResultsQuery<T>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<T> myHashingStrategy;

    public UniqueResultsQuery(Query<T> original) {
        this.myOriginal = original;
        this.myHashingStrategy = TObjectHashingStrategy.CANONICAL;
    }

    public UniqueResultsQuery(Query<T> original, TObjectHashingStrategy<T> hashingStrategy) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    private boolean doForEach(final @NotNull Processor<T> consumer, @Nullable Ref<Set<T>> outProcessed) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.doForEach must not be null");
        }
        final ConcurrentHashSet<T> processedElements = new ConcurrentHashSet<T>(this.myHashingStrategy);
        if (outProcessed != null) {
            outProcessed.set(processedElements);
        }
        return this.myOriginal.forEach(new Processor<T>(){

            @Override
            public boolean process(T t) {
                return !processedElements.add(t) || consumer.process(t);
            }
        });
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.forEach must not be null");
        }
        return this.doForEach(consumer, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<T> findAll() {
        Ref<Set<T>> refProcessed = new Ref<Set<T>>();
        this.doForEach(new Processor<T>(){

            @Override
            public boolean process(T t) {
                return true;
            }
        }, refProcessed);
        Collection collection = refProcessed.get();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

