/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");

    private ReflectionUtil() {
    }

    @Nullable
    public static Type resolveVariable(TypeVariable variable, Class classType) {
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ContainerUtil.findByEquals(ReflectionCache.getTypeParameters(aClass), variable);
        if (index >= 0) {
            return variable;
        }
        Class[] classes = ReflectionCache.getInterfaces(aClass);
        Type[] genericInterfaces = ReflectionCache.getGenericInterfaces(aClass);
        for (int i = 0; i < classes.length; ++i) {
            Type type;
            Class anInterface = classes[i];
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ContainerUtil.findByEquals(ReflectionCache.getTypeParameters(anInterface), typeVariable);
            if (index < 0) {
                LOG.assertTrue(false, "Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\n" + "genericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\n" + "searching in " + ReflectionUtil.declarationToString(anInterface));
            }
            if ((type = genericInterfaces[i]) instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return ReflectionCache.getActualTypeArguments(parameterizedType);
    }

    @Nullable
    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ContainerUtil.findByEquals(ReflectionCache.getTypeParameters(aClass), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    public static ArrayList<Field> collectFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findField(Class clazz, @Nullable Class type, String name) throws NoSuchFieldException {
        ArrayList<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || type != null && !each.getType().equals(type)) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    public static Field findAssignableField(Class clazz, Class type, String name) throws NoSuchFieldException {
        ArrayList<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || !type.isAssignableFrom(each.getType())) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    private static void collectFields(Class clazz, ArrayList<Field> result) {
        Class<?>[] interfaces;
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            result.add(field);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    public static void resetField(Class clazz, Class type, String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Class type, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    private static void resetField(@Nullable Object object, Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, new Integer(0));
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, new Double(0.0));
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, new Float(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(Method[] methods, @NonNls @NotNull String name, Class ... parameters) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.findMethod must not be null");
        }
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionUtil.getMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.getMethod must not be null");
        }
        return ReflectionUtil.findMethod(ReflectionCache.getMethods(aClass), name, parameters);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionUtil.getDeclaredMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.getDeclaredMethod must not be null");
        }
        return ReflectionUtil.findMethod(aClass.getDeclaredMethods(), name, parameters);
    }

    public static Object getField(Class objectClass, Object object, Class type, @NonNls String name) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, type, name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
            return null;
        }
    }
}

