/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionCache {
    private static final boolean CACHE_DISABLED = System.getProperty("java.version", "1.5").indexOf("1.5") < 0;
    private static final ConcurrentFactoryMap<Class, Class> ourSuperClasses = new ConcurrentFactoryMap<Class, Class>(){

        @Override
        protected Class create(Class key) {
            return key.getSuperclass();
        }
    };
    private static final ConcurrentFactoryMap<Class, Class[]> ourInterfaces = new ConcurrentFactoryMap<Class, Class[]>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected Class[] create(Class key) {
            Class[] classArray = key.getInterfaces();
            if (classArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$2.create must not return null");
            }
            return classArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Method[]> ourMethods = new ConcurrentFactoryMap<Class, Method[]>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected Method[] create(Class key) {
            Method[] methodArray = key.getMethods();
            if (methodArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$3.create must not return null");
            }
            return methodArray;
        }
    };
    private static final Map<Class, Map<Class, Boolean>> ourAssignables = new THashMap();
    private static final Object cacheLock = new Object();
    private static final ConcurrentFactoryMap<Class, Boolean> ourIsInterfaces = new ConcurrentFactoryMap<Class, Boolean>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected Boolean create(Class key) {
            Boolean bl = key.isInterface();
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$4.create must not return null");
            }
            return bl;
        }
    };
    private static final ConcurrentFactoryMap<Class, TypeVariable[]> ourTypeParameters = new ConcurrentFactoryMap<Class, TypeVariable[]>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected TypeVariable[] create(Class key) {
            TypeVariable[] typeVariableArray = key.getTypeParameters();
            if (typeVariableArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$5.create must not return null");
            }
            return typeVariableArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Type[]> ourGenericInterfaces = new ConcurrentFactoryMap<Class, Type[]>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected Type[] create(Class key) {
            Type[] typeArray = key.getGenericInterfaces();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$6.create must not return null");
            }
            return typeArray;
        }
    };
    private static final ConcurrentFactoryMap<ParameterizedType, Type[]> ourActualTypeArguments = new ConcurrentFactoryMap<ParameterizedType, Type[]>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected Type[] create(ParameterizedType key) {
            Type[] typeArray = key.getActualTypeArguments();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$7.create must not return null");
            }
            return typeArray;
        }
    };

    private ReflectionCache() {
    }

    public static Class getSuperClass(Class aClass) {
        return (Class)ourSuperClasses.get(aClass);
    }

    public static Class[] getInterfaces(Class aClass) {
        return (Class[])ourInterfaces.get(aClass);
    }

    public static Method[] getMethods(Class aClass) {
        return (Method[])ourMethods.get(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAssignable(Class ancestor, Class descendant) {
        if (ancestor == descendant) {
            return true;
        }
        if (CACHE_DISABLED) {
            return ancestor.isAssignableFrom(descendant);
        }
        Object object = cacheLock;
        synchronized (object) {
            Boolean result;
            THashMap map = ourAssignables.get(ancestor);
            if (map == null) {
                map = new THashMap();
                ourAssignables.put(ancestor, (Map<Class, Boolean>)map);
            }
            if ((result = map.get(descendant)) != null) {
                return result;
            }
            result = ancestor.isAssignableFrom(descendant);
            map.put(descendant, result);
            return result;
        }
    }

    public static boolean isInstance(Object instance, Class clazz) {
        return ReflectionCache.isAssignable(clazz, instance.getClass());
    }

    public static boolean isInterface(Class aClass) {
        return (Boolean)ourIsInterfaces.get(aClass);
    }

    public static <T> TypeVariable<Class<T>>[] getTypeParameters(Class<T> aClass) {
        return (TypeVariable[])ourTypeParameters.get(aClass);
    }

    public static Type[] getGenericInterfaces(Class aClass) {
        return (Type[])ourGenericInterfaces.get(aClass);
    }

    public static Type[] getActualTypeArguments(ParameterizedType type) {
        return (Type[])ourActualTypeArguments.get(type);
    }
}

