/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = new CopyOnWriteArrayList<QueryExecutor<Result, Parameters>>();

    public void registerExecutor(QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.remove(executor);
    }

    public final Query<Result> createQuery(Parameters parameters) {
        return new ExecutorsQuery(parameters, this.getExecutors());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list = this.myExecutors;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/QueryFactory.getExecutors must not return null");
        }
        return list;
    }

    public final Query<Result> createUniqueResultsQuery(Parameters parameters) {
        return new UniqueResultsQuery(new ExecutorsQuery(parameters, this.getExecutors()));
    }

    public final Query<Result> createUniqueResultsQuery(Parameters parameters, TObjectHashingStrategy<Result> hashingStrategy) {
        return new UniqueResultsQuery<Result>(new ExecutorsQuery(parameters, this.getExecutors()), hashingStrategy);
    }
}

