/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProfilingUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ProfilingUtil");
    private static final Controller ourController = ProfilingUtil.initController();
    private static boolean ourCPUProfilingInProgress;

    private ProfilingUtil() {
    }

    @Nullable
    private static Controller initController() {
        try {
            return new Controller();
        }
        catch (Exception ex) {
            LOG.info("Profiling agent is not enabled. Add -agentlib:yjpagent to idea.vmoptions if necessary to profile IDEA.");
            return null;
        }
    }

    public static boolean hasValidController() {
        return ourController != null;
    }

    public static void operationStarted(@NonNls String name) {
        try {
            if (ProfilingUtil.profilingEnabled(name) && ProfilingUtil.hasValidController()) {
                ProfilingUtil.startCPUProfiling();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startCPUProfiling() {
        try {
            if (ProfilingUtil.hasValidController() && !ourCPUProfilingInProgress) {
                ourCPUProfilingInProgress = true;
                ourController.startCPUProfiling(ProfilingUtil.tracingEnabled() ? 12L : 4L, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stopCPUProfiling() {
        try {
            if (ProfilingUtil.hasValidController()) {
                if (ourCPUProfilingInProgress) {
                    ourController.stopCPUProfiling();
                    ourCPUProfilingInProgress = false;
                } else {
                    System.err.println("Nested profiling request ignored");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String captureCPUSnapshot() {
        try {
            if (ProfilingUtil.hasValidController()) {
                if (ourCPUProfilingInProgress) {
                    ourCPUProfilingInProgress = false;
                    String result = ourController.captureSnapshot(0L);
                    ourController.stopCPUProfiling();
                    return result;
                }
                System.err.println("Nested profiling request ignored");
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void operationFinished(@NonNls String name) {
        try {
            if (ProfilingUtil.profilingEnabled(name) && ProfilingUtil.hasValidController()) {
                ProfilingUtil.captureCPUSnapshot();
                ProfilingUtil.captureMemorySnapshot(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void captureMemorySnapshot(String name) {
        LOG.info("captureMemorySnapshot(\"" + name + "\") called");
        if (ProfilingUtil.captureMemorySnapshot() && ProfilingUtil.profilingEnabled(name)) {
            LOG.info("Taking memory snapshot");
            ProfilingUtil.forceCaptureMemorySnapshot();
            try {
                ourController.stopAllocationRecording();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String forceCaptureMemorySnapshot() {
        if (ProfilingUtil.hasValidController()) {
            try {
                return ourController.captureMemorySnapshot();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void startRecordAllocations() {
        if (ProfilingUtil.hasValidController()) {
            try {
                ourController.startAllocationRecording(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void stopRecordAllocations() {
        if (ProfilingUtil.hasValidController()) {
            try {
                ourController.stopAllocationRecording();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String createDumpFileName(String buildNumber) {
        StringBuffer result = new StringBuffer(30);
        result.append(buildNumber).append('_');
        result.append(SystemProperties.getUserName()).append('_');
        result.append(new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date()));
        return result.toString();
    }

    private static boolean captureMemorySnapshot() {
        String p = System.getProperty("profile.memory");
        return p != null && p.equals("true");
    }

    private static boolean tracingEnabled() {
        String p = System.getProperty("profile.trace");
        return p != null && p.equals("true");
    }

    private static boolean profilingEnabled(String name) {
        String p = System.getProperty("profile." + name);
        return p != null && p.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressAndRemoveDataFile(@NonNls String dumpFilePath, String outputFileName, @NonNls String ext) {
        String path = SystemProperties.getUserHome();
        path = path + File.separator;
        File dumpFile = new File(dumpFilePath);
        if (!dumpFile.exists()) {
            return;
        }
        FileInputStream is = null;
        ZipOutputStream zip = null;
        try {
            is = new FileInputStream(dumpFile);
            zip = new ZipOutputStream(new FileOutputStream(path + outputFileName + ".zip"));
            zip.putNextEntry(new ZipEntry(outputFileName + ext));
            FileUtil.copy(is, zip);
            zip.closeEntry();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {}
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ex) {}
            FileUtil.delete(dumpFile);
        }
    }
}

