/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;

public class PatternUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PatternUtil");
    private static final HashMap ourEscapeRulls = new HashMap();

    private static void escape2(char symbol) {
        ourEscapeRulls.put("\\" + symbol, "\\\\" + symbol);
    }

    private static void escape3(char symbol) {
        ourEscapeRulls.put("\\" + symbol, "\\\\\\" + symbol);
    }

    public static String convertToRegex(String mask) {
        String[] strings = mask.split("\\\\", -1);
        StringBuffer pattern = new StringBuffer();
        String separator = "";
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            string = string.replaceAll("\\.", "\\\\.");
            for (String toEscape : ourEscapeRulls.keySet()) {
                string = string.replaceAll(toEscape, (String)ourEscapeRulls.get(toEscape));
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string);
        }
        return pattern.toString();
    }

    public static Pattern fromMask(@NonNls String mask) {
        try {
            return Pattern.compile(PatternUtil.convertToRegex(mask));
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            return Pattern.compile("");
        }
    }

    static {
        ourEscapeRulls.put("\\*", ".*");
        ourEscapeRulls.put("\\?", ".");
        PatternUtil.escape2('+');
        PatternUtil.escape2('(');
        PatternUtil.escape2(')');
        PatternUtil.escape2('[');
        PatternUtil.escape2(']');
        PatternUtil.escape2('/');
        PatternUtil.escape2('^');
        PatternUtil.escape3('$');
        PatternUtil.escape2('{');
        PatternUtil.escape2('}');
        PatternUtil.escape2('|');
    }
}

