/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final EmptyIterator<String> ADD_NOTHING = new EmptyIterator();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = new Function<String, VirtualFile>(){

        @Override
        public VirtualFile fun(String path) {
            return LocalFileSystem.getInstance().findFileByPath(path.replace(File.separatorChar, '/'));
        }
    };
    private static final Function<VirtualFile, String> LOCAL_PATH = new Function<VirtualFile, String>(){

        @Override
        public String fun(VirtualFile file) {
            return PathUtil.getLocalPath(file);
        }
    };
    private static final Function<String, VirtualFile> PATH_TO_DIR = new Function<String, VirtualFile>(){

        @Override
        public VirtualFile fun(String s) {
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(s);
            if (StdFileTypes.ARCHIVE.equals(fileType)) {
                return JarFileSystem.getInstance().findFileByPath(s + "!/");
            }
            return (VirtualFile)PATH_TO_LOCAL_VFILE.fun(s);
        }
    };

    public void add(@NonNls String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPath);
    }

    public void add(VirtualFile file) {
        this.add(LOCAL_PATH.fun(file));
    }

    public void addFirst(@NonNls String path) {
        Iterator<String> elements = this.chooseFirstTimeItems(path);
        int index = 0;
        while (elements.hasNext()) {
            String element = elements.next();
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPathTail);
    }

    private Iterator<String> chooseFirstTimeItems(String path) {
        if (path == null) {
            return ADD_NOTHING;
        }
        final StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        Enumeration<String> en = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return tokenizer.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)tokenizer.nextElement();
            }
        };
        return FilteringIterator.create(ContainerUtil.iterate(en), new Condition<String>(){

            @Override
            public boolean value(String element) {
                return (element = element.trim()).length() != 0 && !PathsList.this.myPathSet.contains(element);
            }
        });
    }

    private void addAllLast(Iterator<String> elememts, List<String> toArray) {
        while (elememts.hasNext()) {
            String element = elememts.next();
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    public String getPathsString() {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        List<String> classPath = this.getPathList();
        for (String path : classPath) {
            buffer.append(separator);
            buffer.append(path);
            separator = File.pathSeparator;
        }
        return buffer.toString();
    }

    public List<String> getPathList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.myPath);
        result.addAll(this.myPathTail);
        return result;
    }

    public List<VirtualFile> getVirtualFiles() {
        return ContainerUtil.skipNulls(ContainerUtil.map(this.getPathList(), PATH_TO_LOCAL_VFILE));
    }

    public List<VirtualFile> getRootDirs() {
        return ContainerUtil.skipNulls(ContainerUtil.map(this.getPathList(), PATH_TO_DIR));
    }

    public void addAll(List<String> allClasspath) {
        for (String path : allClasspath) {
            this.add(path);
        }
    }

    public void addAllFiles(List<File> classpathList) {
        for (File file : classpathList) {
            this.add(PathUtil.getCanonicalPath(file.getAbsolutePath()).replace('/', File.separatorChar));
        }
    }
}

