/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;

public class PathUtil {
    public static String getLocalPath(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem() instanceof JarFileSystem && file.getParent() != null) {
            return null;
        }
        String path = file.getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    public static String getJdkMainAttribute(ProjectJdk jdk, Attributes.Name attributeName) {
        ZipFile manifestJarFile;
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile rtJar = homeDirectory.findFileByRelativePath("jre/lib/rt.jar");
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("lib/rt.jar");
        }
        if (rtJar == null) {
            return null;
        }
        VirtualFile rtJarFileContent = JarFileSystem.getInstance().findFileByPath(rtJar.getPath() + "!/");
        if (rtJarFileContent == null) {
            return null;
        }
        try {
            manifestJarFile = JarFileSystem.getInstance().getJarFile(rtJarFileContent);
        }
        catch (IOException e) {
            return null;
        }
        if (manifestJarFile == null) {
            return null;
        }
        try {
            ZipEntry entry = manifestJarFile.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            InputStream is = manifestJarFile.getInputStream(entry);
            Manifest manifest = new Manifest(is);
            is.close();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(attributeName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getJarPathForClass(Class aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }

    public static String toPresentableUrl(String url) {
        String path = VirtualFileManager.extractPath(url);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    public static final String getCanonicalPath(@NonNls String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        path = path.replace(File.separatorChar, '/');
        StringTokenizer tok = new StringTokenizer(path, "/");
        Stack<String> stack = new Stack<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("..".equals(token)) {
                if (stack.isEmpty()) {
                    return null;
                }
                stack.pop();
                continue;
            }
            if (token.length() == 0 || ".".equals(token)) continue;
            stack.push(token);
        }
        StringBuffer result = new StringBuffer(path.length());
        if (path.charAt(0) == '/') {
            result.append("/");
        }
        for (int i = 0; i < stack.size(); ++i) {
            String str = (String)stack.get(i);
            if (i > 0) {
                result.append('/');
            }
            result.append(str);
        }
        return result.toString();
    }
}

