/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ObjectUtils");
    public static final Null NULL = new Null();

    public static Object defaultIfNull(Object object, Object defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return new StringBuffer().append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object))).toString();
    }

    public static boolean haveSameElements(Object[] expected, Object[] actual) {
        List<Object> actualList;
        List<Object> expectedList = Arrays.asList(expected);
        return new HashSet<Object>(expectedList).equals(new HashSet<Object>(actualList = Arrays.asList(actual))) && expected.length == actual.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T assertNotNull(T t) {
        LOG.assertTrue(t != null);
        T t2 = t;
        if (t2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ObjectUtils.assertNotNull must not return null");
        }
        return t2;
    }

    public static class Null
    implements Serializable {
        private Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

