/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewInstanceFactory<T>
implements Factory<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.NewInstanceFactory");
    private final Constructor myConstructor;
    private final Object[] myArgs;

    private NewInstanceFactory(Constructor constructor, Object[] args) {
        this.myConstructor = constructor;
        this.myArgs = args;
    }

    @Override
    public T create() {
        try {
            return this.myConstructor.newInstance(this.myArgs);
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    public static <T> Factory<T> fromClass(final Class<T> clazz) {
        try {
            return new NewInstanceFactory<T>(clazz.getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY), ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException e) {
            return new Factory<T>(){

                @Override
                public T create() {
                    try {
                        return clazz.newInstance();
                    }
                    catch (Exception e) {
                        LOG.error(e);
                        return null;
                    }
                }
            };
        }
    }
}

