/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeQuery<T, T1 extends T, T2 extends T>
implements Query<T> {
    private Query<T1> myQuery1;
    private Query<T2> myQuery2;

    public MergeQuery(Query<T1> query1, Query<T2> query2) {
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList<Object> results = new ArrayList<Object>();
        results.addAll(this.myQuery1.findAll());
        results.addAll(this.myQuery2.findAll());
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/MergeQuery.findAll must not return null");
        }
        return arrayList;
    }

    @Override
    public T findFirst() {
        T1 r1 = this.myQuery1.findFirst();
        if (r1 != null) {
            return (T)r1;
        }
        return (T)this.myQuery2.findFirst();
    }

    @Override
    public boolean forEach(final @NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/MergeQuery.forEach must not be null");
        }
        Processor wrapper1 = new Processor<T1>(){

            @Override
            public boolean process(T1 t) {
                return consumer.process(t);
            }
        };
        boolean wantMore = this.myQuery1.forEach(wrapper1);
        if (wantMore) {
            Processor wrapper2 = new Processor<T2>(){

                @Override
                public boolean process(T2 t) {
                    return consumer.process(t);
                }
            };
            wantMore = this.myQuery2.forEach(wrapper2);
        }
        return wantMore;
    }

    @Override
    public T[] toArray(T[] a) {
        Collection<T> results = this.findAll();
        return results.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

