/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static IconProvider[] ourIconProviders = null;

    public static Icon getIcon(VirtualFile file, int flags, Project project) {
        ProjectFileIndex projectFileIndex;
        Icon icon = IconUtil.getBaseIcon(file, flags, project);
        Icon excludedIcon = null;
        if (project != null && (projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex()).isInSource(file) && CompilerManager.getInstance(project).isExcludedFromCompilation(file)) {
            excludedIcon = Icons.EXCLUDED_FROM_COMPILE_ICON;
        }
        Icon lockedIcon = null;
        if ((flags & 2) != 0 && !file.isWritable()) {
            lockedIcon = Icons.LOCKED_ICON;
        }
        if (excludedIcon != null || lockedIcon != null) {
            LayeredIcon layeredIcon = new LayeredIcon(1 + (lockedIcon != null ? 1 : 0) + (excludedIcon != null ? 1 : 0));
            int layer = 0;
            layeredIcon.setIcon(icon, layer++);
            if (lockedIcon != null) {
                layeredIcon.setIcon(lockedIcon, layer++);
            }
            if (excludedIcon != null) {
                layeredIcon.setIcon(excludedIcon, layer);
            }
            icon = layeredIcon;
        }
        return icon;
    }

    private static Icon getBaseIcon(VirtualFile file, int flags, Project project) {
        Icon icon;
        Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
        Icon icon2 = icon = providersIcon == null ? file.getIcon() : providersIcon;
        if (project != null) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            boolean isUnderSource = projectFileIndex.isJavaSourceFile(file);
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
            if (fileType == StdFileTypes.JAVA) {
                if (!isUnderSource) {
                    icon = Icons.JAVA_OUTSIDE_SOURCE_ICON;
                } else {
                    PsiClass[] classes;
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(file);
                    if (psiFile instanceof PsiClassOwner && (classes = ((PsiClassOwner)((Object)psiFile)).getClasses()).length > 0) {
                        String fileName = file.getNameWithoutExtension();
                        Icon classIcon = null;
                        for (PsiClass aClass : classes) {
                            if (!Comparing.strEqual(aClass.getName(), fileName)) continue;
                            classIcon = aClass.getIcon(flags);
                            break;
                        }
                        if (classIcon == null) {
                            classIcon = classes[classes.length - 1].getIcon(flags);
                        }
                        icon = classIcon;
                    }
                }
            }
        }
        return icon;
    }

    @Nullable
    private static Icon getProvidersIcon(VirtualFile file, int flags, Project project) {
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file);
        return psiFile == null ? null : IconUtil.getProvidersIcon(psiFile, flags);
    }

    @Nullable
    public static Icon getProvidersIcon(PsiElement element, int flags) {
        for (IconProvider iconProvider : IconUtil.getIconProviders()) {
            Icon icon = iconProvider.getIcon(element, flags);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    private static IconProvider[] getIconProviders() {
        if (ourIconProviders == null) {
            ourIconProviders = ApplicationManager.getApplication().getComponents(IconProvider.class);
        }
        return ourIconProviders;
    }

    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        EmptyIcon emptyIcon = Icons.CLASS_ICON != null ? new EmptyIcon(Icons.CLASS_ICON.getIconWidth(), Icons.CLASS_ICON.getIconHeight()) : null;
        baseIcon.setIcon(emptyIcon, 0);
        if (showVisibility) {
            emptyIcon = Icons.PUBLIC_ICON != null ? new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight()) : null;
            baseIcon.setIcon(emptyIcon, 1);
        }
        return baseIcon;
    }

    public static void setVisibilityIcon(PsiModifierList modifierList, RowIcon baseIcon) {
        if (modifierList != null) {
            if (modifierList.hasModifierProperty("public")) {
                IconUtil.setVisibilityIcon(4, baseIcon);
            } else if (modifierList.hasModifierProperty("private")) {
                IconUtil.setVisibilityIcon(1, baseIcon);
            } else if (modifierList.hasModifierProperty("protected")) {
                IconUtil.setVisibilityIcon(3, baseIcon);
            } else if (modifierList.hasModifierProperty("packageLocal")) {
                IconUtil.setVisibilityIcon(2, baseIcon);
            } else {
                EmptyIcon emptyIcon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else if (Icons.PUBLIC_ICON != null) {
            EmptyIcon emptyIcon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    private static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        switch (accessLevel) {
            case 4: {
                icon = Icons.PUBLIC_ICON;
                break;
            }
            case 3: {
                icon = Icons.PROTECTED_ICON;
                break;
            }
            case 2: {
                icon = Icons.PACKAGE_LOCAL_ICON;
                break;
            }
            case 1: {
                icon = Icons.PRIVATE_ICON;
                break;
            }
            default: {
                if (Icons.PUBLIC_ICON != null) {
                    icon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
                    break;
                }
                return;
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

