/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class FileContentUtil {
    private FileContentUtil() {
    }

    public static void setFileText(@Nullable Project project, VirtualFile virtualFile, String text) throws IOException {
        if (project == null) {
            project = VfsUtil.guessProjectForFile(virtualFile);
        }
        if (project != null) {
            Document document;
            PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
            Document document2 = document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
            if (document != null) {
                document.setText(text != null ? text : "");
                psiDocumentManager.commitDocument(document);
                FileDocumentManager.getInstance().saveDocument(document);
                return;
            }
        }
        VfsUtil.saveText(virtualFile, text != null ? text : "");
        virtualFile.refresh(false, false);
    }
}

