/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutorsQuery<Result, Parameter>
implements Query<Result> {
    private final Parameter myParameters;
    private final List<QueryExecutor<Result, Parameter>> myExecutors;
    private boolean myIsProcessing;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExecutorsQuery.<init> must not be null");
        }
        if (executors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExecutorsQuery.<init> must not be null");
        }
        this.myIsProcessing = false;
        this.myParameters = params;
        this.myExecutors = executors;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Parameter getParameters() {
        Parameter Parameter2 = this.myParameters;
        if (Parameter2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExecutorsQuery.getParameters must not return null");
        }
        return Parameter2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach(processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExecutorsQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator<Result>(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor);
        return (Result)processor.getFoundValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExecutorsQuery.forEach must not be null");
        }
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            for (QueryExecutor<Result, Parameter> executor : this.myExecutors) {
                if (executor.execute(this.myParameters, consumer)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    public Result[] toArray(Result[] a) {
        this.assertNotProcessing();
        Collection<Result> all = this.findAll();
        return all.toArray(a);
    }
}

