/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.treetable.TreeTable;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EditSourceOnDoubleClickHandler {
    public static void install(final JTree tree) {
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(tree);
                Project project = DataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Object lastPathComponent = selectionPath.getLastPathComponent();
                if (((TreeNode)lastPathComponent).isLeaf() || !this.expandOnDoubleClick((TreeNode)lastPathComponent)) {
                    OpenSourceUtil.openSourcesFrom(dataContext, true);
                }
            }

            private boolean expandOnDoubleClick(TreeNode treeNode) {
                Object userObject;
                if (treeNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof NodeDescriptor) {
                    return ((NodeDescriptor)userObject).expandOnDoubleClick();
                }
                return true;
            }
        });
    }

    public static void install(final TreeTable treeTable) {
        treeTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(treeTable);
                Project project = DataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
            }
        });
    }

    public static void install(final Table table) {
        table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (table.columnAtPoint(e.getPoint()) < 0) {
                    return;
                }
                if (table.rowAtPoint(e.getPoint()) < 0) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(table);
                Project project = DataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
            }
        });
    }

    public static void install(final JList list, final Runnable whenPerformed) {
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                if (index == -1) {
                    return;
                }
                if (!list.getCellBounds(index, index).contains(point)) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(list);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                whenPerformed.run();
            }
        });
    }
}

