/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.invokeAll must not be null");
        }
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future = executorService.submit(callable);
                futures.add(future);
            }
            for (Future future : futures) {
                ((FutureTask)future).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> V cacheOrGet(ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        V prev = map.putIfAbsent(key, defaultValue);
        V v = prev == null ? defaultValue : prev;
        if (v == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
        }
        return v;
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(final @NonNls String threadFactoryName) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, threadFactoryName);
            }
        });
    }

    public static ScheduledExecutorService newSingleScheduledThreadExecutor(final @NonNls String threadFactoryName) {
        return new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, threadFactoryName);
            }
        });
    }
}

