/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CommonProcessors {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FindFirstProcessor<T>
    implements Processor<T> {
        private T myValue = null;

        public boolean isFound() {
            return this.myValue != null;
        }

        public T getFoundValue() {
            return this.myValue;
        }

        @Override
        public boolean process(T t) {
            this.myValue = t;
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectUniquesProcessor<T>
    implements Processor<T> {
        private final Set<T> myCollection = new HashSet<T>();

        @Override
        public boolean process(T t) {
            this.myCollection.add(t);
            return true;
        }

        public <T> T[] toArray(T[] a) {
            return this.myCollection.toArray(a);
        }

        public Collection<T> getResults() {
            return this.myCollection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(Collection<T> collection) {
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            this.myCollection.add(t);
            return true;
        }

        public <T> T[] toArray(T[] a) {
            return this.myCollection.toArray(a);
        }

        public Collection<T> getResults() {
            return this.myCollection;
        }
    }
}

