/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.update.ComparableObjectCheck;
import gnu.trove.Equality;
import java.lang.reflect.Array;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Collection[] EMPTY_COLLECTION_ARRAY = new Collection[0];
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);

    public static byte[] realloc(byte[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        byte[] result = new byte[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static int[] realloc(int[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static int[] append(int[] array, int value) {
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    public static char[] realloc(char[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static <T> T[] toObjectArray(Collection<T> collection, Class<T> aClass) {
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        return collection.toArray(array);
    }

    public static Object[] toObjectArray(Collection collection) {
        return ArrayUtil.toObjectArray(collection, Object.class);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return ArrayUtil.toObjectArray(collection, String.class);
    }

    public static <T> T[] mergeArrays(T[] a1, T[] a2, Class<T> aClass) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        Object[] highlights = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, highlights, 0, a1.length);
        System.arraycopy(a2, 0, highlights, a1.length, a2.length);
        return highlights;
    }

    public static int[] mergeArrays(int[] a1, int[] a2) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        int[] a = new int[a1.length + a2.length];
        int idx = 0;
        for (int i : a1) {
            a[idx++] = i;
        }
        for (int i : a2) {
            a[idx++] = i;
        }
        return a;
    }

    public static <T> T[] append(@NotNull T[] src, T element) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        return ArrayUtil.append(src, element, src.getClass().getComponentType());
    }

    public static <T> T[] append(T[] src, T element, Class<T> componentType) {
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static <T> T[] remove(@NotNull T[] src, T element) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            return src;
        }
        return ArrayUtil.remove(src, idx);
    }

    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = new int[src.length - 1];
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.find must not be null");
        }
        for (int i = 0; i < src.length; ++i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    public static int find(@NotNull int[] src, int obj) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.find must not be null");
        }
        for (int i = 0; i < src.length; ++i) {
            int o = src[i];
            if (o != obj) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] array, byte[] subArray) {
        if (array == subArray) {
            return true;
        }
        if (array == null || subArray == null) {
            return false;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean startsWith(E[] array, E[] subArray) {
        if (array == subArray) {
            return true;
        }
        if (array == null || subArray == null) {
            return false;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@NotNull byte[] array, int start, @NotNull byte[] subArray) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.startsWith must not be null");
        }
        if (subArray == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.startsWith must not be null");
        }
        int length = subArray.length;
        if (array.length - start < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, T[] a2, Equality<? super T> comparator) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] reverseArray(T[] array) {
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        return newArray;
    }

    public static int[] reverseArray(int[] array) {
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        return newArray;
    }

    public static int lexicographicCompare(@NotNull String[] obj1, @NotNull String[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        if (obj2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.lexicographicCompare must not be null");
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = o1.compareToIgnoreCase(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> void swap(T[] array, int i1, int i2) {
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(int[] array, int i1, int i2) {
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(T[] array, int i1, int i2) {
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(T[] array, int i1, int i2) {
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    public static int indexOf(Object[] objects, Object object) {
        for (int i = 0; i < objects.length; ++i) {
            if (!ComparableObjectCheck.equals(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] ints, int value) {
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }
}

