/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayQuery<T>
implements Query<T> {
    private T[] myArray;

    public ArrayQuery(T[] array) {
        this.myArray = array;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<T> findAll() {
        List<T> list = Arrays.asList(this.myArray);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayQuery.findAll must not return null");
        }
        return list;
    }

    @Override
    public T findFirst() {
        return this.myArray.length > 0 ? (T)this.myArray[0] : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayQuery.forEach must not be null");
        }
        for (T t : this.myArray) {
            if (consumer.process(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T[] toArray(T[] a) {
        return this.myArray;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.myArray).iterator();
    }
}

