/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.Alarm");
    private boolean myDisposed;
    private List<Request> myRequests = new ArrayList<Request>();
    private final ExecutorService myExecutorService;
    @NonNls
    private static final String THREADS_NAME = "Alarm pool";
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new Thread(r, Alarm.THREADS_NAME);
        }
    };
    private static final ExecutorService ourSharedExecutorService = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final Object LOCK = new Object();
    private final ThreadToUse myThreadToUse;

    public void dispose() {
        this.myDisposed = true;
        this.cancelAllRequests();
        if (this.myThreadToUse == ThreadToUse.OWN_THREAD) {
            this.myExecutorService.shutdown();
        }
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(Disposable parentDisposable) {
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(ThreadToUse threadToUse) {
        this(threadToUse, null);
    }

    public Alarm(ThreadToUse threadToUse, Disposable parentDisposable) {
        this.myThreadToUse = threadToUse;
        ExecutorService executorService = this.myExecutorService = threadToUse == ThreadToUse.OWN_THREAD ? Executors.newSingleThreadExecutor(THREAD_FACTORY) : ourSharedExecutorService;
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, this);
        }
    }

    public void addRequest(Runnable request, int delay) {
        this._addRequest(request, delay, this.myThreadToUse == ThreadToUse.SWING_THREAD ? ModalityState.current() : null);
    }

    public void addRequest(Runnable request, int delay, ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delay, modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addRequest(Runnable request, int delay, ModalityState modalityState) {
        Object object = this.LOCK;
        synchronized (object) {
            Request requestToSchedule = new Request(request, modalityState);
            ScheduledFuture<?> future = JobScheduler.getScheduler().schedule(requestToSchedule, (long)delay, TimeUnit.MILLISECONDS);
            requestToSchedule.setFuture(future);
            this.myRequests.add(requestToSchedule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(Runnable request) {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = this.myRequests.size() - 1; i >= 0; --i) {
                Request r = this.myRequests.get(i);
                if (r.getTask() != request) continue;
                r.cancel();
                this.myRequests.remove(i);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = 0;
            for (Request request : this.myRequests) {
                ++count;
                request.cancel();
            }
            this.myRequests.clear();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;

        public Request(Runnable task, ModalityState modalityState) {
            this.myTask = task;
            this.myModalityState = modalityState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    if (Alarm.this.myDisposed) break block7;
                    final Runnable task = this.myTask;
                    if (task == null) {
                        return;
                    }
                    if (this.myModalityState != null) {
                        Object object = Alarm.this.LOCK;
                        synchronized (object) {
                            Alarm.this.myRequests.remove(this);
                        }
                        ApplicationManager.getApplication().invokeLater(task, this.myModalityState);
                        break block7;
                    }
                    this.myFuture = Alarm.this.myExecutorService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = Alarm.this.LOCK;
                            synchronized (object) {
                                Alarm.this.myRequests.remove(Request.this);
                            }
                            task.run();
                        }
                    });
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        public Runnable getTask() {
            return this.myTask;
        }

        public Future<?> getFuture() {
            return this.myFuture;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.myFuture = future;
        }

        public ModalityState getModalityState() {
            return this.myModalityState;
        }

        private void cancel() {
            this.myFuture.cancel(false);
            this.myTask = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        OWN_THREAD;

    }
}

