/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.ReadWriteAccessUsage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;

public class UsageTypeGroupingRule
implements UsageGroupingRule {
    public UsageGroup groupUsage(Usage usage) {
        if (usage instanceof PsiElementUsage) {
            PsiElementUsage elementUsage = (PsiElementUsage)usage;
            UsageType usageType = this.getUsageType(elementUsage.getElement());
            if (usageType != null) {
                return new UsageTypeGroup(usageType);
            }
            if (usage instanceof ReadWriteAccessUsage) {
                ReadWriteAccessUsage u = (ReadWriteAccessUsage)usage;
                if (u.isAccessedForWriting()) {
                    return new UsageTypeGroup(UsageType.WRITE);
                }
                if (u.isAccessedForReading()) {
                    return new UsageTypeGroup(UsageType.READ);
                }
            }
            return new UsageTypeGroup(UsageType.UNCLASSIFIED);
        }
        return null;
    }

    private UsageType getUsageType(PsiElement element) {
        UsageTypeProvider[] providers;
        if (element == null) {
            return null;
        }
        UsageType classUsageType = this.getClassUsageType(element);
        if (classUsageType != null) {
            return classUsageType;
        }
        if (element instanceof PsiLiteralExpression) {
            return UsageType.LITERAL_USAGE;
        }
        if (PsiTreeUtil.getParentOfType(element, PsiComment.class, false) != null) {
            return UsageType.COMMENT_USAGE;
        }
        for (UsageTypeProvider provider : providers = (UsageTypeProvider[])Extensions.getExtensions(UsageTypeProvider.EP_NAME)) {
            UsageType usageType = provider.getUsageType(element);
            if (usageType == null) continue;
            return usageType;
        }
        return null;
    }

    private UsageType getClassUsageType(PsiElement element) {
        PsiJavaCodeReferenceElement classReference;
        PsiTypeElement retType;
        PsiReferenceExpression expression;
        PsiTypeCastExpression castExpression;
        if (PsiTreeUtil.getParentOfType(element, PsiImportStatement.class, false) != null) {
            return UsageType.CLASS_IMPORT;
        }
        PsiReferenceList referenceList = PsiTreeUtil.getParentOfType(element, PsiReferenceList.class);
        if (referenceList != null) {
            if (referenceList.getParent() instanceof PsiClass) {
                return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
            }
            if (referenceList.getParent() instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_THROWS_LIST;
            }
        }
        if ((castExpression = PsiTreeUtil.getParentOfType(element, PsiTypeCastExpression.class)) != null && PsiTreeUtil.isAncestor(castExpression.getCastType(), element, true)) {
            return UsageType.CLASS_CAST_TO;
        }
        PsiInstanceOfExpression instanceOfExpression = PsiTreeUtil.getParentOfType(element, PsiInstanceOfExpression.class);
        if (instanceOfExpression != null && PsiTreeUtil.isAncestor(instanceOfExpression.getCheckType(), element, true)) {
            return UsageType.CLASS_INSTANCE_OF;
        }
        if (PsiTreeUtil.getParentOfType(element, PsiClassObjectAccessExpression.class) != null) {
            return UsageType.CLASS_CLASS_OBJECT_ACCESS;
        }
        if (element instanceof PsiReferenceExpression && (expression = (PsiReferenceExpression)element).resolve() instanceof PsiClass) {
            return UsageType.CLASS_STATIC_MEMBER_ACCESS;
        }
        PsiParameter psiParameter = PsiTreeUtil.getParentOfType(element, PsiParameter.class);
        if (psiParameter != null) {
            PsiElement scope = psiParameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiCatchSection) {
                return UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiForeachStatement) {
                return UsageType.CLASS_LOCAL_VAR_DECLARATION;
            }
            return null;
        }
        PsiField psiField = PsiTreeUtil.getParentOfType(element, PsiField.class);
        if (psiField != null && PsiTreeUtil.isAncestor(psiField.getTypeElement(), element, true)) {
            return UsageType.CLASS_FIELD_DECLARATION;
        }
        PsiLocalVariable psiLocalVar = PsiTreeUtil.getParentOfType(element, PsiLocalVariable.class);
        if (psiLocalVar != null && PsiTreeUtil.isAncestor(psiLocalVar.getTypeElement(), element, true)) {
            return UsageType.CLASS_LOCAL_VAR_DECLARATION;
        }
        PsiMethod psiMethod = PsiTreeUtil.getParentOfType(element, PsiMethod.class);
        if (psiMethod != null && (retType = psiMethod.getReturnTypeElement()) != null && PsiTreeUtil.isAncestor(retType, element, true)) {
            return UsageType.CLASS_METHOD_RETURN_TYPE;
        }
        PsiNewExpression psiNewExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        if (psiNewExpression != null && (classReference = psiNewExpression.getClassReference()) != null && PsiTreeUtil.isAncestor(classReference, element, false)) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        return null;
    }

    private class UsageTypeGroup
    implements UsageGroup {
        private UsageType myUsageType;

        public void update() {
        }

        public UsageTypeGroup(UsageType usageType) {
            this.myUsageType = usageType;
        }

        public Icon getIcon(boolean isOpen) {
            return null;
        }

        public String getText(UsageView view) {
            return this.myUsageType.toString();
        }

        public FileStatus getFileStatus() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void navigate(boolean focus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageTypeGroup)) {
                return false;
            }
            UsageTypeGroup usageTypeGroup = (UsageTypeGroup)o;
            return !(this.myUsageType != null ? !this.myUsageType.equals(usageTypeGroup.myUsageType) : usageTypeGroup.myUsageType != null);
        }

        public int hashCode() {
            return this.myUsageType != null ? this.myUsageType.hashCode() : 0;
        }
    }
}

