/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.Icons;
import javax.swing.Icon;

public class PackageGroupingRule
implements UsageGroupingRule {
    private Project myProject;

    public PackageGroupingRule(Project project) {
        this.myProject = project;
    }

    public UsageGroup groupUsage(Usage usage) {
        UsageInFile usageInFile;
        VirtualFile file;
        if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null) {
            PsiPackage aPackage;
            VirtualFile dir = file.getParent();
            if (dir == null) {
                return null;
            }
            PsiDirectory psiDirectory = PsiManager.getInstance(this.myProject).findDirectory(dir);
            if (psiDirectory != null && (aPackage = psiDirectory.getPackage()) != null) {
                return new PackageGroup(aPackage);
            }
            return new DirectoryGroup(dir);
        }
        return null;
    }

    private class DirectoryGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private VirtualFile myDir;

        public void update() {
        }

        public DirectoryGroup(VirtualFile dir) {
            this.myDir = dir;
        }

        public Icon getIcon(boolean isOpen) {
            return isOpen ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON;
        }

        public String getText(UsageView view) {
            return this.myDir.getPresentableUrl();
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? FileStatusManager.getInstance(PackageGroupingRule.this.myProject).getStatus(this.myDir) : null;
        }

        public boolean isValid() {
            return this.myDir.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            PsiDirectory directory = this.getDirectory();
            if (directory != null && directory.canNavigate()) {
                directory.navigate(focus);
            }
        }

        private PsiDirectory getDirectory() {
            return PsiManager.getInstance(PackageGroupingRule.this.myProject).findDirectory(this.myDir);
        }

        public boolean canNavigate() {
            PsiDirectory directory = this.getDirectory();
            return directory != null && directory.canNavigate();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DirectoryGroup)) {
                return false;
            }
            return this.myDir.equals(((DirectoryGroup)o).myDir);
        }

        public int hashCode() {
            return this.myDir.hashCode();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (DataKeys.VIRTUAL_FILE == key) {
                sink.put(DataKeys.VIRTUAL_FILE, this.myDir);
            }
            if (DataKeys.PSI_ELEMENT == key) {
                sink.put(DataKeys.PSI_ELEMENT, this.getDirectory());
            }
        }
    }

    private class PackageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private PsiPackage myPackage;
        private Icon myOpenIcon;
        private Icon myClosedIcon;

        public PackageGroup(PsiPackage aPackage) {
            this.myPackage = aPackage;
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myOpenIcon = this.myPackage.getIcon(4);
                this.myClosedIcon = this.myPackage.getIcon(8);
            }
        }

        public Icon getIcon(boolean isOpen) {
            return isOpen ? this.myOpenIcon : this.myClosedIcon;
        }

        public String getText(UsageView view) {
            return this.myPackage.getQualifiedName();
        }

        public FileStatus getFileStatus() {
            if (!this.isValid()) {
                return null;
            }
            PsiDirectory[] dirs = this.myPackage.getDirectories();
            return dirs.length == 1 ? FileStatusManager.getInstance(PackageGroupingRule.this.myProject).getStatus(dirs[0].getVirtualFile()) : null;
        }

        public boolean isValid() {
            return this.myPackage.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            this.myPackage.navigate(focus);
        }

        public boolean canNavigate() {
            return this.myPackage.canNavigate();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageGroup)) {
                return false;
            }
            return this.myPackage.equals(((PackageGroup)o).myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (DataKeys.PSI_ELEMENT == key) {
                sink.put(DataKeys.PSI_ELEMENT, this.myPackage);
            }
        }
    }
}

