/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import javax.swing.Icon;

public class ModuleGroupingRule
implements UsageGroupingRule {
    public UsageGroup groupUsage(Usage usage) {
        UsageInLibrary usageInLibrary;
        OrderEntry entry;
        UsageInModule usageInModule;
        Module module;
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            return new ModuleUsageGroup(module);
        }
        if (usage instanceof UsageInLibrary && (entry = (usageInLibrary = (UsageInLibrary)usage).getLibraryEntry()) != null) {
            return new LibraryUsageGroup(entry);
        }
        return null;
    }

    private static class ModuleUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final Module myModule;

        public ModuleUsageGroup(Module module) {
            this.myModule = module;
        }

        public void update() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return !(this.myModule != null ? !this.myModule.equals(moduleUsageGroup.myModule) : moduleUsageGroup.myModule != null);
        }

        public int hashCode() {
            return this.myModule != null ? this.myModule.hashCode() : 0;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myModule.getModuleType().getNodeIcon(isOpen);
        }

        public String getText(UsageView view) {
            return this.myModule.getName();
        }

        public FileStatus getFileStatus() {
            return null;
        }

        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(UsageGroup o) {
            if (o instanceof LibraryUsageGroup) {
                return -1;
            }
            return this.getText(null).compareTo(o.getText(null));
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (DataKeys.MODULE_CONTEXT == key) {
                sink.put(DataKeys.MODULE_CONTEXT, this.myModule);
            }
        }
    }

    private static class LibraryUsageGroup
    implements UsageGroup {
        public static final Icon LIBRARY_ICON = IconLoader.getIcon("/nodes/ppLibOpen.png");
        OrderEntry myEntry;

        public void update() {
        }

        public LibraryUsageGroup(OrderEntry entry) {
            this.myEntry = entry;
        }

        public Icon getIcon(boolean isOpen) {
            return LIBRARY_ICON;
        }

        public String getText(UsageView view) {
            return this.myEntry.getPresentableName();
        }

        public FileStatus getFileStatus() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public int compareTo(UsageGroup usageGroup) {
            if (usageGroup instanceof ModuleUsageGroup) {
                return 1;
            }
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LibraryUsageGroup)) {
                return false;
            }
            return this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }
    }
}

