/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;

public class MethodGroupingRule
implements UsageGroupingRule {
    private static final Logger LOG = Logger.getInstance("#com.intellij.usages.impl.rules.MethodGroupingRule");

    public UsageGroup groupUsage(Usage usage) {
        PsiElement psiElement;
        if (usage instanceof PsiElementUsage && (psiElement = ((PsiElementUsage)usage).getElement()).getContainingFile() instanceof PsiJavaFile) {
            PsiElement containingMethod = psiElement;
            while ((containingMethod = PsiTreeUtil.getParentOfType(containingMethod, PsiMethod.class, true)) != null && ((PsiMethod)containingMethod).getContainingClass().getQualifiedName() == null) {
            }
            if (containingMethod != null) {
                return new MethodUsageGroup((PsiMethod)containingMethod);
            }
        }
        return null;
    }

    private static class MethodUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private SmartPsiElementPointer myMethodPointer;
        private String myName;
        private Icon myIcon;

        public MethodUsageGroup(PsiMethod psiMethod) {
            this.myName = PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            this.myMethodPointer = SmartPointerManager.getInstance(psiMethod.getProject()).createLazyPointer(psiMethod);
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = MethodUsageGroup.getIconImpl(this.getMethod());
            }
        }

        private static Icon getIconImpl(PsiMethod psiMethod) {
            return psiMethod.getIcon(3);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodUsageGroup)) {
                return false;
            }
            MethodUsageGroup group = (MethodUsageGroup)object;
            if (this.isValid() && group.isValid()) {
                return this.getMethod().getManager().areElementsEquivalent(this.getMethod(), group.getMethod());
            }
            return Comparing.equal(this.myName, ((MethodUsageGroup)object).myName);
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        private PsiMethod getMethod() {
            return (PsiMethod)this.myMethodPointer.getElement();
        }

        public String getText(UsageView view) {
            return this.myName;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? this.getMethod().getFileStatus() : null;
        }

        public boolean isValid() {
            PsiMethod method = this.getMethod();
            return method != null && method.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getMethod().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(UsageGroup usageGroup) {
            if (!(usageGroup instanceof MethodUsageGroup)) {
                LOG.error("MethodUsageGroup expected but " + usageGroup.getClass() + " found");
            }
            return this.myName.compareTo(((MethodUsageGroup)usageGroup).myName);
        }

        public void calcData(DataKey key, DataSink sink) {
            PsiMethod method;
            if (!this.isValid()) {
                return;
            }
            if (DataKeys.PSI_ELEMENT == key) {
                sink.put(DataKeys.PSI_ELEMENT, this.getMethod());
            }
            if (UsageView.USAGE_INFO_KEY == key && (method = this.getMethod()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, new UsageInfo(method));
            }
        }
    }
}

