/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class FileGroupingRule
implements UsageGroupingRule {
    private Project myProject;

    public FileGroupingRule(Project project) {
        this.myProject = project;
    }

    public UsageGroup groupUsage(Usage usage) {
        if (usage instanceof UsageInFile) {
            return new FileUsageGroup(this.myProject, ((UsageInFile)usage).getFile());
        }
        return null;
    }

    protected static class FileUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final Project myProject;
        private final VirtualFile myFile;
        private String myPresentableName;
        private Icon myIcon;

        public FileUsageGroup(Project project, VirtualFile file) {
            this.myProject = project;
            this.myFile = file;
            this.myPresentableName = this.myFile.getName();
            this.update();
        }

        private Icon getIconImpl() {
            return IconUtil.getIcon(this.myFile, 2, this.myProject);
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = this.getIconImpl();
                this.myPresentableName = this.myFile.getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileUsageGroup)) {
                return false;
            }
            FileUsageGroup fileUsageGroup = (FileUsageGroup)o;
            return !(this.myFile != null ? !this.myFile.equals(fileUsageGroup.myFile) : fileUsageGroup.myFile != null);
        }

        public int hashCode() {
            return this.myFile != null ? this.myFile.hashCode() : 0;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        public String getText(UsageView view) {
            return this.myPresentableName;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? FileStatusManager.getInstance(this.myProject).getStatus(this.myFile) : null;
        }

        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            FileEditorManager.getInstance(this.myProject).openFile(this.myFile, focus);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == DataKeys.VIRTUAL_FILE) {
                VirtualFile file = this.myFile != null && this.myFile.isValid() ? this.myFile : null;
                sink.put(DataKeys.VIRTUAL_FILE, file);
            }
            if (key == DataKeys.PSI_ELEMENT) {
                sink.put(DataKeys.PSI_ELEMENT, this.getPsiFile());
            }
        }

        @Nullable
        public PsiFile getPsiFile() {
            return this.myFile != null && this.myFile.isValid() ? PsiManager.getInstance(this.myProject).findFile(this.myFile) : null;
        }
    }
}

