/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

class UsageViewTreeCellRenderer
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.usages.impl.UsageViewTreeCellRenderer");
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    private static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes(ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));
    private static final SimpleTextAttributes ourReadOnlyAttributes = SimpleTextAttributes.fromTextAttributes(ourColorsScheme.getAttributes(UsageTreeColors.READONLY_PREFIX));
    private final SimpleTextAttributes myNumberOfUsagesAttribute;
    private final UsageViewPresentation myPresentation;
    private final UsageView myView;

    public UsageViewTreeCellRenderer(UsageView view) {
        this.myView = view;
        this.myPresentation = view.getPresentation();
        EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        this.myNumberOfUsagesAttribute = SimpleTextAttributes.fromTextAttributes(colorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES));
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean showAsReadOnly = false;
        if (value instanceof Node && value != tree.getModel().getRoot()) {
            Node node = (Node)value;
            if (!node.isValid()) {
                this.append(UsageViewBundle.message("node.invalid", new Object[0]) + " ", ourInvalidAttributes);
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof UsageTarget) {
                String text;
                UsageTarget usageTarget = (UsageTarget)userObject;
                ItemPresentation presentation = usageTarget.getPresentation();
                LOG.assertTrue(presentation != null);
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", ourReadOnlyAttributes);
                }
                this.append((text = presentation.getPresentableText()) != null ? text : "", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(presentation.getIcon(expanded));
            } else if (treeNode instanceof GroupNode) {
                GroupNode node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    this.append(StringUtil.capitalize(this.myPresentation.getUsagesWord()), UsageViewTreeCellRenderer.patchAttrs(node, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                } else {
                    this.append(node.getGroup().getText(this.myView), UsageViewTreeCellRenderer.patchAttrs(node, showAsReadOnly ? ourReadOnlyAttributes : SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    this.setIcon(node.getGroup().getIcon(expanded));
                }
                int count = node.getRecursiveUsageCount();
                this.append(" (" + StringUtil.pluralize(count + " " + this.myPresentation.getUsagesWord(), count) + ")", UsageViewTreeCellRenderer.patchAttrs(node, this.myNumberOfUsagesAttribute));
            } else if (treeNode instanceof UsageNode) {
                TextChunk[] text;
                UsageNode node = (UsageNode)treeNode;
                this.setIcon(node.getUsage().getPresentation().getIcon());
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", UsageViewTreeCellRenderer.patchAttrs(node, ourReadOnlyAttributes));
                }
                for (TextChunk textChunk : text = node.getUsage().getPresentation().getText()) {
                    this.append(textChunk.getText(), UsageViewTreeCellRenderer.patchAttrs(node, SimpleTextAttributes.fromTextAttributes(textChunk.getAttributes())));
                }
            } else if (userObject instanceof String) {
                this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(userObject == null ? "" : userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static SimpleTextAttributes patchAttrs(Node node, SimpleTextAttributes original) {
        if (node.isExcluded()) {
            original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
        }
        if (node instanceof GroupNode) {
            DefaultMutableTreeNode parent;
            FileStatus fileStatus;
            UsageGroup group = ((GroupNode)node).getGroup();
            FileStatus fileStatus2 = fileStatus = group != null ? group.getFileStatus() : null;
            if (fileStatus != null && fileStatus != FileStatus.NOT_CHANGED) {
                original = new SimpleTextAttributes(original.getStyle(), fileStatus.getColor(), original.getWaveColor());
            }
            if ((parent = (DefaultMutableTreeNode)node.getParent()) != null && parent.isRoot()) {
                original = new SimpleTextAttributes(original.getStyle() | 1, original.getFgColor(), original.getWaveColor());
            }
        }
        return original;
    }

    public static String getTooltipText(Object value) {
        DefaultMutableTreeNode treeNode;
        if (value instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)value) instanceof UsageNode) {
            UsageNode node = (UsageNode)treeNode;
            return node.getUsage().getPresentation().getTooltipText();
        }
        return null;
    }
}

