/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageModelTracker;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.ExporterToTextFile;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageNodeTreeBuilder;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewTreeCellRenderer;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.OrderableUsageGroupingRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageViewImpl
implements UsageView,
UsageModelTracker.UsageModelTrackerListener {
    @NonNls
    public static final String SHOW_RECENT_FIND_USAGES_ACTION_ID = "UsageView.ShowRecentFindUsages";
    private final UsageNodeTreeBuilder myBuilder;
    private final MyPanel myRootPanel;
    private final JTree myTree;
    private Content myContent;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] myTargets;
    private final Factory<UsageSearcher> myUsageSearcherFactory;
    private final Project myProject;
    private boolean mySearchInProgress = true;
    private ExporterToTextFile myTextFileExporter;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Alarm myFlushAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private final UsageModelTracker myModelTracker;
    private final Set<Usage> myUsages = new ConcurrentHashSet<Usage>();
    private final Map<Usage, UsageNode> myUsageNodes = new ConcurrentHashMap<Usage, UsageNode>();
    private static final UsageNode NULL_NODE = new UsageNode(new NullUsage(), new UsageViewTreeModelBuilder(new UsageViewPresentation(), new UsageTarget[0]));
    private final ButtonPanel myButtonPanel = new ButtonPanel();
    private volatile boolean isDisposed;
    private boolean myChangesDetected = false;
    private final Queue<Usage> myUsagesToFlush = new ConcurrentLinkedQueue<Usage>();
    private final List<Disposable> myDisposables = new ArrayList<Disposable>();
    static final Comparator<Usage> USAGE_COMPARATOR = new Comparator<Usage>(){

        @Override
        public int compare(Usage o1, Usage o2) {
            if (o1 == NULL_NODE || o2 == NULL_NODE) {
                return -1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                int selfcompared = ((Comparable)((Object)o1)).compareTo(o2);
                if (selfcompared != 0) {
                    return selfcompared;
                }
                if (o1 instanceof UsageInFile && o2 instanceof UsageInFile) {
                    UsageInFile u1 = (UsageInFile)o1;
                    UsageInFile u2 = (UsageInFile)o2;
                    VirtualFile f1 = u1.getFile();
                    VirtualFile f2 = u2.getFile();
                    if (f1 != null && f1.isValid() && f2 != null && f2.isValid()) {
                        return f1.getPresentableUrl().compareTo(f2.getPresentableUrl());
                    }
                }
                return 0;
            }
            return -1;
        }
    };
    @NonNls
    private static final String HELP_ID = "ideaInterface.find";
    private UsagePreviewPanel myUsagePreviewPanel;
    private JPanel myCentralPanel;
    private static final Icon PREVIEW_ICON = IconLoader.getIcon("/actions/preview.png");
    private final GroupNode myRoot;
    private volatile boolean myIsFirstVisibleUsageFound = false;

    public UsageViewImpl(UsageViewPresentation presentation, UsageTarget[] targets, Factory<UsageSearcher> usageSearcherFactory, Project project) {
        this.myPresentation = presentation;
        this.myTargets = targets;
        this.myUsageSearcherFactory = usageSearcherFactory;
        this.myProject = project;
        this.myTree = new Tree(){
            {
                ToolTipManager.sharedInstance().registerComponent(this);
            }

            public String getToolTipText(MouseEvent e) {
                TreePath path = this.getPathForLocation(e.getX(), e.getY());
                if (path != null && this.getCellRenderer() instanceof UsageViewTreeCellRenderer) {
                    return UsageViewTreeCellRenderer.getTooltipText(path.getLastPathComponent());
                }
                return null;
            }

            public boolean isPathEditable(TreePath path) {
                return path.getLastPathComponent() instanceof UsageViewTreeModelBuilder.TargetsRootNode;
            }
        };
        this.myRootPanel = new MyPanel(this.myTree);
        this.myModelTracker = new UsageModelTracker(project);
        final UsageViewTreeModelBuilder model = new UsageViewTreeModelBuilder(this.myPresentation, targets);
        this.myRoot = (GroupNode)model.getRoot();
        this.myBuilder = new UsageNodeTreeBuilder(UsageViewImpl.getActiveGroupingRules(project), UsageViewImpl.getActiveFilteringRules(project), this.myRoot);
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UsageViewImpl.this.isDisposed) {
                        return;
                    }
                    UsageViewImpl.this.myTree.setModel(model);
                    UsageViewImpl.this.myRootPanel.setLayout(new BorderLayout());
                    JPanel toolbarPanel = new JPanel(new BorderLayout());
                    toolbarPanel.add((Component)UsageViewImpl.this.createActionsToolbar(), "West");
                    toolbarPanel.add((Component)UsageViewImpl.this.createFiltersToolbar(), "Center");
                    UsageViewImpl.this.myRootPanel.add((Component)toolbarPanel, "West");
                    UsageViewImpl.this.myCentralPanel = new JPanel();
                    UsageViewImpl.this.myCentralPanel.setLayout(new BorderLayout());
                    UsageViewImpl.this.myRootPanel.add((Component)UsageViewImpl.this.myCentralPanel, "Center");
                    UsageViewImpl.this.setupCentralPanel();
                    UsageViewImpl.this.initTree();
                    UsageViewImpl.this.myTree.setCellRenderer(new UsageViewTreeCellRenderer(UsageViewImpl.this));
                    UsageViewImpl.this.collapseAll();
                    UsageViewImpl.this.myModelTracker.addListener(UsageViewImpl.this);
                    if (UsageViewImpl.this.myPresentation.isShowCancelButton()) {
                        UsageViewImpl.this.addButtonToLowerPane(new Runnable(){

                            public void run() {
                                UsageViewImpl.this.close();
                            }
                        }, UsageViewBundle.message("usage.view.cancel.button", new Object[0]));
                    }
                    UsageViewImpl.this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                        public void valueChanged(TreeSelectionEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (UsageViewImpl.this.isDisposed) {
                                        return;
                                    }
                                    List infos = UsageViewImpl.this.getSelectedUsageInfos();
                                    if (infos != null && UsageViewImpl.this.myUsagePreviewPanel != null) {
                                        UsageViewImpl.this.myUsagePreviewPanel.updateLayout(infos);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void setupCentralPanel() {
        this.myCentralPanel.removeAll();
        if (this.myUsagePreviewPanel != null) {
            this.myUsagePreviewPanel.dispose();
            this.myUsagePreviewPanel = null;
        }
        if (UsageViewSettings.getInstance().IS_PREVIEW_USAGES) {
            Splitter splitter = new Splitter(false, UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS);
            splitter.setFirstComponent(ScrollPaneFactory.createScrollPane(this.myTree));
            this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject);
            splitter.setSecondComponent(this.myUsagePreviewPanel);
            this.myCentralPanel.add((Component)splitter, "Center");
        } else {
            this.myCentralPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTree), "Center");
        }
        this.myCentralPanel.add((Component)this.myButtonPanel, "South");
        this.myRootPanel.revalidate();
    }

    private static UsageFilteringRule[] getActiveFilteringRules(Project project) {
        UsageFilteringRuleProvider[] providers = ApplicationManager.getApplication().getComponents(UsageFilteringRuleProvider.class);
        ArrayList<UsageFilteringRule> list = new ArrayList<UsageFilteringRule>();
        for (UsageFilteringRuleProvider provider : providers) {
            list.addAll(Arrays.asList(provider.getActiveRules(project)));
        }
        return list.toArray(new UsageFilteringRule[list.size()]);
    }

    private static UsageGroupingRule[] getActiveGroupingRules(Project project) {
        UsageGroupingRuleProvider[] providers = ApplicationManager.getApplication().getComponents(UsageGroupingRuleProvider.class);
        ArrayList<UsageGroupingRule> list = new ArrayList<UsageGroupingRule>();
        for (UsageGroupingRuleProvider provider : providers) {
            list.addAll(Arrays.asList(provider.getActiveRules(project)));
        }
        Collections.sort(list, new Comparator<UsageGroupingRule>(){

            @Override
            public int compare(UsageGroupingRule o1, UsageGroupingRule o2) {
                return this.getRank(o1) - this.getRank(o2);
            }

            private int getRank(UsageGroupingRule rule) {
                if (rule instanceof OrderableUsageGroupingRule) {
                    return ((OrderableUsageGroupingRule)rule).getRank();
                }
                return Integer.MAX_VALUE;
            }
        });
        return list.toArray(new UsageGroupingRule[list.size()]);
    }

    @Override
    public void modelChanged(boolean isPropertyChange) {
        if (!isPropertyChange) {
            this.myChangesDetected = true;
        }
        this.updateLater();
    }

    private void initTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        SmartExpander.installOn(this.myTree);
        TreeUtil.installActions(this.myTree);
        EditSourceOnDoubleClickHandler.install(this.myTree);
        this.myTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    Navigatable navigatable;
                    TreePath leadSelectionPath = UsageViewImpl.this.myTree.getLeadSelectionPath();
                    if (leadSelectionPath == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
                    if (node instanceof UsageNode) {
                        Usage usage = ((UsageNode)node).getUsage();
                        usage.navigate(false);
                        usage.highlightInEditor();
                    } else if (node.isLeaf() && (navigatable = UsageViewImpl.getNavigatableForNode(node)) != null && navigatable.canNavigate()) {
                        navigatable.navigate(false);
                    }
                }
            }
        });
        PopupHandler.installPopupHandler(this.myTree, "UsageView.Popup", "UsageViewPopup");
    }

    private JComponent createActionsToolbar() {
        AnAction[] actions;
        DefaultActionGroup group = new DefaultActionGroup(){

            public void update(AnActionEvent e) {
                super.update(e);
                UsageViewImpl.this.myButtonPanel.update();
            }
        };
        for (AnAction action : actions = this.createActions()) {
            if (action == null) continue;
            group.add(action);
        }
        return UsageViewImpl.toUsageViewToolbar(group);
    }

    private static JComponent toUsageViewToolbar(DefaultActionGroup group) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", group, false);
        return actionToolbar.getComponent();
    }

    private JComponent createFiltersToolbar() {
        AnAction[] filteringActions;
        AnAction[] groupingActions;
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction groupingAction : groupingActions = this.createGroupingActions()) {
            group.add(groupingAction);
        }
        final JComponent component = this.getComponent();
        final MergeDupLines mergeDupLines = new MergeDupLines();
        mergeDupLines.registerCustomShortcutSet(mergeDupLines.getShortcutSet(), component);
        this.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                mergeDupLines.unregisterCustomShortcutSet(component);
            }
        });
        group.add(mergeDupLines);
        for (AnAction filteringAction : filteringActions = this.createFilteringActions()) {
            group.add(filteringAction);
        }
        group.add(new RuleAction(this, UsageViewBundle.message("preview.usages.action.text", new Object[0]), PREVIEW_ICON){

            protected boolean getOptionValue() {
                return UsageViewSettings.getInstance().IS_PREVIEW_USAGES;
            }

            protected void setOptionValue(boolean value) {
                UsageViewSettings.getInstance().IS_PREVIEW_USAGES = value;
            }
        });
        return UsageViewImpl.toUsageViewToolbar(group);
    }

    public void scheduleDisposeOnClose(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    private AnAction[] createActions() {
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                UsageViewImpl.this.expandAll();
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                UsageViewImpl.this.collapseAll();
            }

            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myTextFileExporter = new ExporterToTextFile(this);
        final JComponent component = this.getComponent();
        final AnAction expandAllAction = actionsManager.createExpandAllAction(treeExpander, component);
        final AnAction collapseAllAction = actionsManager.createCollapseAllAction(treeExpander, component);
        this.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                collapseAllAction.unregisterCustomShortcutSet(component);
                expandAllAction.unregisterCustomShortcutSet(component);
            }
        });
        return new AnAction[]{this.canPerformReRun() ? new ReRunAction() : null, new CloseAction(), this.createRecentFindUsagesAction(), expandAllAction, collapseAllAction, actionsManager.createPrevOccurenceAction(this.myRootPanel), actionsManager.createNextOccurenceAction(this.myRootPanel), actionsManager.installAutoscrollToSourceHandler(this.myProject, this.myTree, new MyAutoScrollToSourceOptionProvider()), actionsManager.createExportToTextFileAction(this.myTextFileExporter), actionsManager.createHelpAction(HELP_ID)};
    }

    private AnAction createRecentFindUsagesAction() {
        AnAction action = ActionManager.getInstance().getAction(SHOW_RECENT_FIND_USAGES_ACTION_ID);
        action.registerCustomShortcutSet(action.getShortcutSet(), this.getComponent());
        return action;
    }

    private AnAction[] createGroupingActions() {
        UsageGroupingRuleProvider[] providers = ApplicationManager.getApplication().getComponents(UsageGroupingRuleProvider.class);
        ArrayList<AnAction> list = new ArrayList<AnAction>();
        for (UsageGroupingRuleProvider provider : providers) {
            list.addAll(Arrays.asList(provider.createGroupingActions(this)));
        }
        return list.toArray(new AnAction[list.size()]);
    }

    private AnAction[] createFilteringActions() {
        UsageFilteringRuleProvider[] providers = ApplicationManager.getApplication().getComponents(UsageFilteringRuleProvider.class);
        ArrayList<AnAction> list = new ArrayList<AnAction>();
        for (UsageFilteringRuleProvider provider : providers) {
            list.addAll(Arrays.asList(provider.createFilteringActions(this)));
        }
        return list.toArray(new AnAction[list.size()]);
    }

    public void rulesChanged() {
        final ArrayList<UsageState> states = new ArrayList<UsageState>();
        this.captureUsagesExpandState(new TreePath(this.myTree.getModel().getRoot()), states);
        final ArrayList<Usage> allUsages = new ArrayList<Usage>(this.myUsageNodes.keySet());
        Collections.sort(allUsages, USAGE_COMPARATOR);
        this.reset();
        this.myBuilder.setGroupingRules(UsageViewImpl.getActiveGroupingRules(this.myProject));
        this.myBuilder.setFilteringRules(UsageViewImpl.getActiveFilteringRules(this.myProject));
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                for (Usage usage : allUsages) {
                    if (!usage.isValid()) continue;
                    if (usage instanceof MergeableUsage) {
                        ((MergeableUsage)((Object)usage)).reset();
                    }
                    UsageViewImpl.this.appendUsage(usage);
                }
            }
        });
        this.setupCentralPanel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (UsageViewImpl.this.isDisposed) {
                    return;
                }
                UsageViewImpl.this.restoreUsageExpandState(states);
                UsageViewImpl.this.updateImmediately();
            }
        });
    }

    private void captureUsagesExpandState(TreePath pathFrom, Collection<UsageState> states) {
        if (!this.myTree.isExpanded(pathFrom)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathFrom.getLastPathComponent();
        int childCount = node.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = node.getChildAt(idx);
            if (child instanceof UsageNode) {
                Usage usage = ((UsageNode)child).getUsage();
                states.add(new UsageState(usage, this.myTree.getSelectionModel().isPathSelected(pathFrom.pathByAddingChild(child))));
                continue;
            }
            this.captureUsagesExpandState(pathFrom.pathByAddingChild(child), states);
        }
    }

    private void restoreUsageExpandState(Collection<UsageState> states) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!(child instanceof GroupNode)) continue;
            TreePath treePath = new TreePath(child.getPath());
            this.myTree.expandPath(treePath);
        }
        this.myTree.getSelectionModel().clearSelection();
        for (UsageState usageState : states) {
            usageState.restore();
        }
    }

    private void expandAll() {
        TreeUtil.expandAll(this.myTree);
    }

    private void collapseAll() {
        TreeUtil.collapseAll(this.myTree, 3);
        TreeUtil.expand(this.myTree, 2);
    }

    public DefaultMutableTreeNode getModelRoot() {
        return (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
    }

    public void select() {
        if (this.myTree != null) {
            this.myTree.requestFocusInWindow();
        }
    }

    private void refreshUsages() {
        this.reset();
        this.doReRun();
    }

    private void doReRun() {
        Runnable process = new Runnable(){

            public void run() {
                UsageViewImpl.this.setSearchInProgress(true);
                final UsageViewManager usageViewManager = UsageViewManager.getInstance(UsageViewImpl.this.myProject);
                usageViewManager.setCurrentSearchCancelled(false);
                UsageViewImpl.this.myChangesDetected = false;
                UsageSearcher usageSearcher = (UsageSearcher)UsageViewImpl.this.myUsageSearcherFactory.create();
                usageSearcher.generate(new Processor<Usage>(){

                    @Override
                    public boolean process(Usage usage) {
                        if (usageViewManager.searchHasBeenCancelled()) {
                            return false;
                        }
                        UsageViewImpl.this.appendUsageLater(usage);
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        return indicator == null || !indicator.isCanceled();
                    }
                });
                UsageViewImpl.this.setSearchInProgress(false);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.myProject, UsageViewManagerImpl.getProgressTitle(this.myPresentation), process, null, null);
    }

    private void reset() {
        this.myUsageNodes.clear();
        this.myIsFirstVisibleUsageFound = false;
        if (!this.myPresentation.isDetachedMode()) {
            ((UsageViewTreeModelBuilder)this.myTree.getModel()).reset();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UsageViewImpl.this.isDisposed) {
                        return;
                    }
                    TreeUtil.expand(UsageViewImpl.this.myTree, 2);
                }
            });
        }
        this.myUsages.clear();
    }

    public void appendUsageLater(Usage usage) {
        this.myUsagesToFlush.offer(usage);
        if (this.myUsagesToFlush.size() > 50) {
            this.flush();
        }
        this.myFlushAlarm.cancelAllRequests();
        this.myFlushAlarm.addRequest(new Runnable(){

            public void run() {
                UsageViewImpl.this.flush();
            }
        }, 300);
    }

    private void flush() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                Usage usage;
                while ((usage = (Usage)UsageViewImpl.this.myUsagesToFlush.poll()) != null) {
                    UsageViewImpl.this.appendUsage(usage);
                }
            }
        });
    }

    @Override
    public void appendUsage(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.appendUsage must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!usage.isValid()) {
            return;
        }
        this.myUsages.add(usage);
        UsageNode node = this.myBuilder.appendUsage(usage);
        this.myUsageNodes.put(usage, node == null ? NULL_NODE : node);
        if (!this.myIsFirstVisibleUsageFound && node != null) {
            this.myIsFirstVisibleUsageFound = true;
            this.showNode(node);
        }
    }

    @Override
    public void removeUsage(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.removeUsage must not be null");
        }
        final UsageNode node = this.myUsageNodes.remove(usage);
        if (node != NULL_NODE && node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UsageViewImpl.this.isDisposed) {
                        return;
                    }
                    TreeModel treeModel = UsageViewImpl.this.myTree.getModel();
                    ((DefaultTreeModel)treeModel).removeNodeFromParent(node);
                    ((GroupNode)UsageViewImpl.this.myTree.getModel().getRoot()).removeUsage(node);
                }
            });
        }
    }

    @Override
    public void includeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.includeUsages must not be null");
        }
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            node.setUsageExcluded(false);
        }
        this.updateImmediately();
    }

    @Override
    public void excludeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.excludeUsages must not be null");
        }
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            node.setUsageExcluded(true);
        }
        this.updateImmediately();
    }

    @Override
    public void selectUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.selectUsages must not be null");
        }
        LinkedList<TreePath> paths = new LinkedList<TreePath>();
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            paths.add(new TreePath(node.getPath()));
        }
        this.myTree.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        if (!paths.isEmpty()) {
            this.myTree.scrollPathToVisible((TreePath)paths.get(0));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JComponent getComponent() {
        MyPanel myPanel = this.myRootPanel;
        if (myPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewImpl.getComponent must not return null");
        }
        return myPanel;
    }

    @Override
    public int getUsagesCount() {
        return this.myUsageNodes.size();
    }

    public void setContent(Content content) {
        this.myContent = content;
        content.setDisposer(this);
    }

    private void updateImmediately() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.checkNodeValidity((DefaultMutableTreeNode)this.myTree.getModel().getRoot());
        if (this.myUsagePreviewPanel != null) {
            this.myUsagePreviewPanel.updateLayout(this.getSelectedUsageInfos());
        }
    }

    private void checkNodeValidity(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            this.checkNodeValidity((DefaultMutableTreeNode)enumeration.nextElement());
        }
        if (node instanceof Node && node != this.getModelRoot()) {
            ((Node)node).update(this);
        }
    }

    private void updateLater() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(new Runnable(){

            public void run() {
                if (UsageViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                PsiDocumentManager.getInstance(UsageViewImpl.this.myProject).commitAllDocuments();
                UsageViewImpl.this.updateImmediately();
            }
        }, 300);
    }

    @Override
    public void close() {
        UsageViewManager.getInstance(this.myProject).setCurrentSearchCancelled(true);
        com.intellij.usageView.UsageViewManager.getInstance(this.myProject).closeContent(this.myContent);
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
        for (Disposable disposable : this.myDisposables) {
            disposable.dispose();
        }
        this.myDisposables.clear();
        this.myModelTracker.removeListener(this);
        this.myModelTracker.dispose();
        this.myUpdateAlarm.cancelAllRequests();
        this.myRootPanel.dispose();
        if (this.myUsagePreviewPanel != null) {
            UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS = ((Splitter)this.myUsagePreviewPanel.getParent()).getProportion();
            this.myUsagePreviewPanel.dispose();
            this.myUsagePreviewPanel = null;
        }
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchInProgress;
    }

    public void setSearchInProgress(boolean searchInProgress) {
        this.mySearchInProgress = searchInProgress;
        this.flush();
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UsageViewImpl.this.isDisposed) {
                        return;
                    }
                    UsageNode firstUsageNode = ((UsageViewTreeModelBuilder)UsageViewImpl.this.myTree.getModel()).getFirstUsageNode();
                    if (firstUsageNode != null) {
                        UsageViewImpl.this.showNode(firstUsageNode);
                    }
                }
            });
        }
    }

    private void showNode(final UsageNode node) {
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (UsageViewImpl.this.isDisposed) {
                        return;
                    }
                    TreePath usagePath = new TreePath(node.getPath());
                    UsageViewImpl.this.myTree.expandPath(usagePath.getParentPath());
                    UsageViewImpl.this.myTree.setSelectionPath(usagePath);
                }
            });
        }
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addButtonToLowerPane must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addButtonToLowerPane must not be null");
        }
        int index = this.myButtonPanel.getComponentCount();
        if (index > 0 && this.myPresentation.isShowCancelButton()) {
            --index;
        }
        this.myButtonPanel.add(index, runnable, text);
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text, char mnemonic) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addButtonToLowerPane must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addButtonToLowerPane must not be null");
        }
        this.addButtonToLowerPane(runnable, text);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, @NotNull String shortDescription) {
        if (processRunnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addPerformOperationAction must not be null");
        }
        if (shortDescription == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/usages/impl/UsageViewImpl.addPerformOperationAction must not be null");
        }
        this.addButtonToLowerPane(new MyPerformOperationRunnable(cannotMakeString, processRunnable, commandName), shortDescription);
    }

    private boolean allTargetsAreValid() {
        for (UsageTarget target : this.myTargets) {
            if (target.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public UsageViewPresentation getPresentation() {
        return this.myPresentation;
    }

    private boolean canPerformReRun() {
        return this.myUsageSearcherFactory != null;
    }

    private void checkReadonlyUsages() {
        Set<VirtualFile> readOnlyUsages = this.getReadOnlyUsagesFiles();
        if (!readOnlyUsages.isEmpty()) {
            ReadonlyStatusHandler.getInstance(this.myProject).ensureFilesWritable(readOnlyUsages.toArray(new VirtualFile[readOnlyUsages.size()]));
        }
    }

    private Set<Usage> getReadOnlyUsages() {
        THashSet result = new THashSet();
        Set<Map.Entry<Usage, UsageNode>> usages = this.myUsageNodes.entrySet();
        for (Map.Entry<Usage, UsageNode> entry : usages) {
            Usage usage = entry.getKey();
            UsageNode node = entry.getValue();
            if (node == null || node == NULL_NODE || node.isExcluded() || !usage.isReadOnly()) continue;
            result.add(usage);
        }
        return result;
    }

    private Set<VirtualFile> getReadOnlyUsagesFiles() {
        Set<Usage> usages = this.getReadOnlyUsages();
        THashSet result = new THashSet();
        for (Usage usage : usages) {
            if (usage instanceof UsageInFile) {
                UsageInFile usageInFile = (UsageInFile)usage;
                result.add(usageInFile.getFile());
            }
            if (!(usage instanceof UsageInFiles)) continue;
            UsageInFiles usageInFiles = (UsageInFiles)((Object)usage);
            result.addAll(Arrays.asList(usageInFiles.getFiles()));
        }
        for (UsageTarget target : this.myTargets) {
            VirtualFile[] files = target.getFiles();
            if (files == null) continue;
            result.addAll(Arrays.asList(files));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Usage> getExcludedUsages() {
        THashSet result = new THashSet();
        Collection<UsageNode> usageNodes = this.myUsageNodes.values();
        for (UsageNode node : usageNodes) {
            if (node == NULL_NODE || node == null || !node.isExcluded()) continue;
            result.add(node.getUsage());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewImpl.getExcludedUsages must not return null");
        }
        return tHashSet;
    }

    private Node getSelectedNode() {
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        if (leadSelectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
        return node instanceof Node ? (Node)node : null;
    }

    private Node[] getSelectedNodes() {
        TreePath[] leadSelectionPath = this.myTree.getSelectionPaths();
        if (leadSelectionPath == null || leadSelectionPath.length == 0) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (TreePath comp : leadSelectionPath) {
            Object lastPathComponent = comp.getLastPathComponent();
            if (!(lastPathComponent instanceof Node)) continue;
            Node node = (Node)lastPathComponent;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new Node[result.size()]);
    }

    @Override
    public Set<Usage> getSelectedUsages() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet usages = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            UsageViewImpl.collectUsages(node, (Set<Usage>)usages);
        }
        return usages;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Usage> getUsages() {
        Set<Usage> set = this.myUsages;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewImpl.getUsages must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<Usage> getSortedUsages() {
        ArrayList<Usage> usages = new ArrayList<Usage>(this.myUsages);
        Collections.sort(usages, USAGE_COMPARATOR);
        ArrayList<Usage> arrayList = usages;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewImpl.getSortedUsages must not return null");
        }
        return arrayList;
    }

    private static void collectUsages(DefaultMutableTreeNode node, Set<Usage> usages) {
        UsageNode usageNode;
        Usage usage;
        if (node instanceof UsageNode && (usage = (usageNode = (UsageNode)node).getUsage()).isValid()) {
            usages.add(usage);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectUsages(child, usages);
        }
    }

    private UsageTarget[] getSelectedUsageTargets() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet targets = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            UsageTargetNode usageTargetNode;
            UsageTarget target;
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof UsageTargetNode) || (target = (usageTargetNode = (UsageTargetNode)lastPathComponent).getTarget()) == null || !target.isValid()) continue;
            targets.add(target);
        }
        return targets.isEmpty() ? null : targets.toArray(new UsageTarget[targets.size()]);
    }

    private static Navigatable getNavigatableForNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)userObject;
            return navigatable.canNavigate() ? navigatable : null;
        }
        return null;
    }

    private static Navigatable[] getNavigatablesForNodes(Node[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Navigatable> result = new ArrayList<Navigatable>();
        for (Node node : nodes) {
            Object userObject;
            if (!node.isDataValid() || !((userObject = node.getUserObject()) instanceof Navigatable)) continue;
            result.add((Navigatable)userObject);
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    public boolean areTargetsValid() {
        return ((UsageViewTreeModelBuilder)this.myTree.getModel()).areTargetsValid();
    }

    private List<UsageInfo> getSelectedUsageInfos() {
        return (List)DataManager.getInstance().getDataContext(this.myRootPanel).getData(USAGE_INFO_LIST_KEY.getName());
    }

    public GroupNode getRoot() {
        return this.myRoot;
    }

    private class MyPerformOperationRunnable
    implements Runnable {
        private final String myCannotMakeString;
        private final Runnable myProcessRunnable;
        private final String myCommandName;

        public MyPerformOperationRunnable(String cannotMakeString, Runnable processRunnable, String commandName) {
            this.myCannotMakeString = cannotMakeString;
            this.myProcessRunnable = processRunnable;
            this.myCommandName = commandName;
        }

        public void run() {
            UsageViewImpl.this.checkReadonlyUsages();
            PsiDocumentManager.getInstance(UsageViewImpl.this.myProject).commitAllDocuments();
            if (this.myCannotMakeString != null && UsageViewImpl.this.myChangesDetected) {
                if (UsageViewImpl.this.canPerformReRun() && UsageViewImpl.this.allTargetsAreValid()) {
                    int answer = Messages.showYesNoDialog(UsageViewImpl.this.myProject, this.myCannotMakeString + "\n" + UsageViewBundle.message("dialog.rerun.search", new Object[0]), UsageViewBundle.message("error.common.title", new Object[0]), Messages.getErrorIcon());
                    if (answer == 0) {
                        UsageViewImpl.this.refreshUsages();
                    }
                } else {
                    Messages.showMessageDialog(UsageViewImpl.this.myProject, this.myCannotMakeString, UsageViewBundle.message("error.common.title", new Object[0]), Messages.getErrorIcon());
                }
                return;
            }
            UsageViewImpl.this.close();
            CommandProcessor.getInstance().executeCommand(UsageViewImpl.this.myProject, new Runnable(){

                public void run() {
                    MyPerformOperationRunnable.this.myProcessRunnable.run();
                }
            }, this.myCommandName, null);
        }
    }

    private class UsageState {
        private final Usage myUsage;
        private final boolean mySelected;

        public UsageState(Usage usage, boolean isSelected) {
            this.myUsage = usage;
            this.mySelected = isSelected;
        }

        public void restore() {
            UsageNode node = (UsageNode)UsageViewImpl.this.myUsageNodes.get(this.myUsage);
            if (node == NULL_NODE || node == null) {
                return;
            }
            DefaultMutableTreeNode parentGroupingNode = (DefaultMutableTreeNode)node.getParent();
            if (parentGroupingNode != null) {
                TreePath treePath = new TreePath(parentGroupingNode.getPath());
                UsageViewImpl.this.myTree.expandPath(treePath);
                if (this.mySelected) {
                    UsageViewImpl.this.myTree.addSelectionPath(treePath.pathByAddingChild(node));
                }
            }
        }
    }

    private final class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            this.setLayout(new FlowLayout(0, 8, 0));
        }

        public void add(int index, final Runnable runnable, String text) {
            JButton button = new JButton(UIUtil.replaceMnemonicAmpersand(text));
            DialogUtil.registerMnemonic(button);
            button.setFocusable(false);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    runnable.run();
                }
            });
            this.add((Component)button, index);
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }

        void update() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                button.setEnabled(!UsageViewImpl.this.isSearchInProgress());
            }
        }
    }

    private static class MyAutoScrollToSourceOptionProvider
    implements AutoScrollToSourceOptionProvider {
        private MyAutoScrollToSourceOptionProvider() {
        }

        public boolean isAutoScrollMode() {
            return UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE;
        }

        public void setAutoScrollMode(boolean state) {
            UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE = state;
        }
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider,
    OccurenceNavigator {
        @Nullable
        private OccurenceNavigatorSupport mySupport;

        public MyPanel(JTree tree) {
            this.mySupport = new OccurenceNavigatorSupport(tree){

                protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                    if (node.getChildCount() > 0) {
                        return null;
                    }
                    if (node instanceof Node && !((Node)node).isValid()) {
                        return null;
                    }
                    return UsageViewImpl.getNavigatableForNode(node);
                }

                public String getNextOccurenceActionName() {
                    return UsageViewBundle.message("action.next.occurrence", new Object[0]);
                }

                public String getPreviousOccurenceActionName() {
                    return UsageViewBundle.message("action.previous.occurrence", new Object[0]);
                }
            };
        }

        private void dispose() {
            this.mySupport = null;
        }

        public boolean hasNextOccurence() {
            return this.mySupport != null && this.mySupport.hasNextOccurence();
        }

        public boolean hasPreviousOccurence() {
            return this.mySupport != null && this.mySupport.hasPreviousOccurence();
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.mySupport != null ? this.mySupport.goNextOccurence() : null;
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.mySupport != null ? this.mySupport.goPreviousOccurence() : null;
        }

        public String getNextOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getNextOccurenceActionName() : "";
        }

        public String getPreviousOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getPreviousOccurenceActionName() : "";
        }

        public void calcData(DataKey key, DataSink sink) {
            Node node = UsageViewImpl.this.getSelectedNode();
            if (key == DataKeys.PROJECT) {
                sink.put(DataKeys.PROJECT, UsageViewImpl.this.myProject);
            } else if (key == UsageView.USAGE_VIEW_KEY) {
                sink.put(UsageView.USAGE_VIEW_KEY, UsageViewImpl.this);
            } else if (key == DataKeys.NAVIGATABLE_ARRAY) {
                sink.put(DataKeys.NAVIGATABLE_ARRAY, UsageViewImpl.getNavigatablesForNodes(UsageViewImpl.this.getSelectedNodes()));
            } else if (key == DataKeys.EXPORTER_TO_TEXT_FILE) {
                sink.put(DataKeys.EXPORTER_TO_TEXT_FILE, UsageViewImpl.this.myTextFileExporter);
            } else if (key == UsageView.USAGES_KEY) {
                Set<Usage> selectedUsages = UsageViewImpl.this.getSelectedUsages();
                sink.put(UsageView.USAGES_KEY, selectedUsages != null ? selectedUsages.toArray(new Usage[selectedUsages.size()]) : null);
            } else if (key == UsageView.USAGE_TARGETS_KEY) {
                sink.put(UsageView.USAGE_TARGETS_KEY, UsageViewImpl.this.getSelectedUsageTargets());
            } else if (key == DataKeys.VIRTUAL_FILE_ARRAY) {
                Set<Usage> usages = UsageViewImpl.this.getSelectedUsages();
                VirtualFile[] data = this.provideVirtualFileArray(usages != null ? usages.toArray(new Usage[usages.size()]) : null, UsageViewImpl.this.getSelectedUsageTargets());
                sink.put(DataKeys.VIRTUAL_FILE_ARRAY, data);
            } else if (key == DataKeys.HELP_ID) {
                sink.put(DataKeys.HELP_ID, UsageViewImpl.HELP_ID);
            } else if (node != null) {
                DataProvider dataProvider;
                Object data;
                Object userObject = node.getUserObject();
                if (userObject instanceof TypeSafeDataProvider) {
                    ((TypeSafeDataProvider)userObject).calcData(key, sink);
                } else if (userObject instanceof DataProvider && (data = (dataProvider = (DataProvider)userObject).getData(key.getName())) != null) {
                    sink.put(key, data);
                }
            }
        }

        private VirtualFile[] provideVirtualFileArray(Usage[] usages, UsageTarget[] usageTargets) {
            if (usages == null && usageTargets == null) {
                return null;
            }
            THashSet result = new THashSet();
            if (usages != null) {
                for (Navigatable navigatable : usages) {
                    if (!navigatable.isValid()) continue;
                    if (navigatable instanceof UsageInFile) {
                        result.add(((UsageInFile)navigatable).getFile());
                    }
                    if (!(navigatable instanceof UsageInFiles)) continue;
                    result.addAll(Arrays.asList(((UsageInFiles)((Object)navigatable)).getFiles()));
                }
            }
            if (usageTargets != null) {
                for (Navigatable navigatable : usageTargets) {
                    VirtualFile[] files;
                    if (!navigatable.isValid() || (files = navigatable.getFiles()) == null) continue;
                    result.addAll(Arrays.asList(files));
                }
            }
            return result.toArray(new VirtualFile[result.size()]);
        }
    }

    private class ReRunAction
    extends AnAction {
        public ReRunAction() {
            super(UsageViewBundle.message("action.rerun", new Object[0]), UsageViewBundle.message("action.description.rerun", new Object[0]), IconLoader.getIcon("/actions/refreshUsages.png"));
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), UsageViewImpl.this.myRootPanel);
        }

        public void actionPerformed(AnActionEvent e) {
            UsageViewImpl.this.refreshUsages();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(UsageViewImpl.this.allTargetsAreValid());
        }
    }

    private class MergeDupLines
    extends RuleAction {
        public MergeDupLines() {
            super(UsageViewImpl.this, UsageViewBundle.message("action.merge.same.line", new Object[0]), IconLoader.getIcon("/toolbar/filterdups.png"));
            this.setShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128)));
        }

        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().IS_FILTER_DUPLICATED_LINE;
        }

        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().IS_FILTER_DUPLICATED_LINE = value;
        }
    }

    private class CloseAction
    extends AnAction {
        private CloseAction() {
            super(UsageViewBundle.message("action.close", new Object[0]), null, IconLoader.getIcon("/actions/cancel.png"));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(UsageViewImpl.this.myContent != null);
        }

        public void actionPerformed(AnActionEvent e) {
            UsageViewImpl.this.close();
        }
    }
}

