/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagePreviewPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.usages.impl.UsagePreviewPanel");
    private Editor myEditor;
    private final Project myProject;
    private String myTitle;
    private volatile boolean isDisposed = false;
    private static final Key<Boolean> IN_PREVIEW_USAGE_FLAG = Key.create("IN_PREVIEW_USAGE_FLAG");
    private static final Key<UsagePreviewPanel> PREVIEW_EDITOR_FLAG = Key.create("PREVIEW_EDITOR_FLAG");

    public UsagePreviewPanel(Project project) {
        this.myProject = project;
        this.setLayout(new BorderLayout());
    }

    private void resetEditor(final @NotNull List<UsageInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsagePreviewPanel.resetEditor must not be null");
        }
        PsiElement psiElement = infos.get(0).getElement();
        if (psiElement == null) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(this.myProject).getInjectionHost(psiFile);
        if (host != null && (psiFile = host.getContainingFile()) == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance(psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        String title = UsageViewBundle.message("preview.title", psiFile.getName());
        if (this.myEditor == null || document != this.myEditor.getDocument() || !Comparing.strEqual(title, this.myTitle)) {
            this.releaseEditor();
            this.removeAll();
            this.myEditor = this.createEditor(psiFile, document);
            if (this.myEditor == null) {
                return;
            }
            this.myTitle = title;
            JLabel titleComp = new JLabel(this.myTitle);
            this.add((Component)titleComp, "North");
            this.add((Component)this.myEditor.getComponent(), "Center");
            this.revalidate();
        }
        final Editor editor = this.myEditor;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UsagePreviewPanel.this.highlight(infos, editor);
            }
        });
    }

    private void highlight(List<UsageInfo> infos, Editor editor) {
        if (editor != this.myEditor) {
            return;
        }
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            if (highlighter.getUserData(IN_PREVIEW_USAGE_FLAG) == null) continue;
            markupModel.removeHighlighter(highlighter);
        }
        for (int i = infos.size() - 1; i >= 0; --i) {
            PsiFile psiFile;
            PsiElement nameElement;
            TextRange infoRange;
            TextRange textRange;
            UsageInfo info = infos.get(i);
            PsiElement psiElement = info.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            int offsetInFile = psiElement.getTextOffset();
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextRange elementRange = psiElement.getTextRange();
            TextRange textRange2 = textRange = elementRange.contains(infoRange = info.getRange()) ? elementRange.cutOut(infoRange) : elementRange;
            if (psiElement instanceof PsiNamedElement && !(psiElement instanceof PsiFile) && (nameElement = (psiFile = psiElement.getContainingFile()).findElementAt(offsetInFile)) != null) {
                textRange = nameElement.getTextRange();
            }
            textRange = InjectedLanguageManager.getInstance(this.myProject).injectedToHost(psiElement, textRange);
            RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 3000, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
            this.myEditor.getCaretModel().moveToOffset(textRange.getEndOffset());
        }
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    private Editor createEditor(PsiFile psiFile, Document document) {
        if (this.isDisposed) {
            return null;
        }
        Project project = psiFile.getProject();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, psiFile.getFileType(), true);
        EditorSettings settings = editor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setVirtualSpace(true);
        editor.putUserData(PREVIEW_EDITOR_FLAG, this);
        return editor;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.releaseEditor();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getProject() != this.myProject || editor.getUserData(PREVIEW_EDITOR_FLAG) != this) continue;
            LOG.error("Editor was not released:" + editor);
        }
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myEditor = null;
        }
    }

    public void updateLayout(List<UsageInfo> infos) {
        if (infos == null) {
            this.releaseEditor();
            this.myTitle = null;
            this.removeAll();
            JLabel titleComp = new JLabel(UsageViewBundle.message("select.the.usage.to.preview", new Object[0]));
            this.add((Component)titleComp, "Center");
            this.revalidate();
        } else {
            this.resetEditor(infos);
        }
    }
}

