/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageGroupingRule;
import org.jetbrains.annotations.NotNull;

class UsageNodeTreeBuilder {
    private GroupNode myRoot;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    public UsageNodeTreeBuilder(@NotNull UsageGroupingRule[] groupingRules, @NotNull UsageFilteringRule[] filteringRules, @NotNull GroupNode root) {
        if (groupingRules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageNodeTreeBuilder.<init> must not be null");
        }
        if (filteringRules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageNodeTreeBuilder.<init> must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageNodeTreeBuilder.<init> must not be null");
        }
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
    }

    public void setGroupingRules(@NotNull UsageGroupingRule[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageNodeTreeBuilder.setGroupingRules must not be null");
        }
        this.myGroupingRules = rules;
    }

    public void setFilteringRules(@NotNull UsageFilteringRule[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageNodeTreeBuilder.setFilteringRules must not be null");
        }
        this.myFilteringRules = rules;
    }

    synchronized UsageNode appendUsage(Usage usage) {
        for (UsageFilteringRule rule : this.myFilteringRules) {
            if (rule.isVisible(usage)) continue;
            return null;
        }
        GroupNode lastGroupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroupingRule rule = this.myGroupingRules[i];
            UsageGroup group = rule.groupUsage(usage);
            if (group == null) continue;
            lastGroupNode = lastGroupNode.addGroup(group, i);
        }
        return lastGroupNode.addUsage(usage);
    }
}

