/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.ClassGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.MethodGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.NonJavaFileGroupingRule;
import com.intellij.usages.impl.rules.PackageGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.util.Icons;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UsageGroupingRuleProviderImpl
implements UsageGroupingRuleProvider,
JDOMExternalizable {
    public boolean GROUP_BY_USAGE_TYPE = true;
    public boolean GROUP_BY_MODULE = true;
    public boolean GROUP_BY_PACKAGE = true;
    public boolean GROUP_BY_FILE_STRUCTURE = true;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public UsageGroupingRule[] getActiveRules(Project project) {
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        rules.add(new NonCodeUsageGroupingRule());
        if (this.GROUP_BY_USAGE_TYPE) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (this.GROUP_BY_MODULE) {
            rules.add(new ModuleGroupingRule());
        }
        if (this.GROUP_BY_PACKAGE) {
            rules.add(new PackageGroupingRule(project));
        }
        if (this.GROUP_BY_FILE_STRUCTURE) {
            FileStructureGroupRuleProvider[] providers;
            rules.add(new ClassGroupingRule());
            rules.add(new MethodGroupingRule());
            rules.add(new NonJavaFileGroupingRule(project));
            for (FileStructureGroupRuleProvider ruleProvider : providers = (FileStructureGroupRuleProvider[])Extensions.getExtensions(FileStructureGroupRuleProvider.EP_NAME)) {
                UsageGroupingRule rule = ruleProvider.getUsageGroupingRule();
                if (rule == null) continue;
                rules.add(rule);
            }
        } else {
            rules.add(new FileGroupingRule(project));
        }
        UsageGroupingRule[] usageGroupingRuleArray = rules.toArray(new UsageGroupingRule[rules.size()]);
        if (usageGroupingRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.getActiveRules must not return null");
        }
        return usageGroupingRuleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] createGroupingActions(UsageView view) {
        AnAction[] anActionArray;
        UsageViewImpl impl = (UsageViewImpl)view;
        final JComponent component = impl.getComponent();
        final GroupByModuleTypeAction groupByModuleTypeAction = new GroupByModuleTypeAction(impl);
        groupByModuleTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), component);
        final GroupByFileStructureAction groupByFileStructureAction = new GroupByFileStructureAction(impl);
        groupByFileStructureAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(77, 128)), component);
        impl.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                groupByModuleTypeAction.unregisterCustomShortcutSet(component);
                groupByFileStructureAction.unregisterCustomShortcutSet(component);
            }
        });
        if (view.getPresentation().isCodeUsages()) {
            final GroupByUsageTypeAction groupByUsageTypeAction = new GroupByUsageTypeAction(impl);
            groupByUsageTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(84, 128)), component);
            final GroupByPackageAction groupByPackageAction = new GroupByPackageAction(impl);
            groupByPackageAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(80, 128)), component);
            impl.scheduleDisposeOnClose(new Disposable(){

                public void dispose() {
                    groupByUsageTypeAction.unregisterCustomShortcutSet(component);
                    groupByPackageAction.unregisterCustomShortcutSet(component);
                }
            });
            anActionArray = new AnAction[]{groupByUsageTypeAction, groupByModuleTypeAction, groupByPackageAction, groupByFileStructureAction};
            if (anActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.createGroupingActions must not return null");
            return anActionArray;
        }
        anActionArray = new AnAction[]{groupByModuleTypeAction, groupByFileStructureAction};
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.createGroupingActions must not return null");
    }

    @NotNull
    public String getComponentName() {
        if ("UsageGroupingRuleProvider" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.getComponentName must not return null");
        }
        return "UsageGroupingRuleProvider";
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private class GroupByFileStructureAction
    extends RuleAction {
        public GroupByFileStructureAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.file.structure", new Object[0]), IconLoader.getIcon("/actions/groupByMethod.png"));
        }

        protected boolean getOptionValue() {
            return UsageGroupingRuleProviderImpl.this.GROUP_BY_FILE_STRUCTURE;
        }

        protected void setOptionValue(boolean value) {
            UsageGroupingRuleProviderImpl.this.GROUP_BY_FILE_STRUCTURE = value;
        }
    }

    private class GroupByPackageAction
    extends RuleAction {
        public GroupByPackageAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.package", new Object[0]), Icons.GROUP_BY_PACKAGES);
        }

        protected boolean getOptionValue() {
            return UsageGroupingRuleProviderImpl.this.GROUP_BY_PACKAGE;
        }

        protected void setOptionValue(boolean value) {
            UsageGroupingRuleProviderImpl.this.GROUP_BY_PACKAGE = value;
        }
    }

    private class GroupByModuleTypeAction
    extends RuleAction {
        public GroupByModuleTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.module", new Object[0]), IconLoader.getIcon("/objectBrowser/showModules.png"));
        }

        protected boolean getOptionValue() {
            return UsageGroupingRuleProviderImpl.this.GROUP_BY_MODULE;
        }

        protected void setOptionValue(boolean value) {
            UsageGroupingRuleProviderImpl.this.GROUP_BY_MODULE = value;
        }
    }

    private class GroupByUsageTypeAction
    extends RuleAction {
        public GroupByUsageTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.usage.type", new Object[0]), IconLoader.getIcon("/ant/filter.png"));
        }

        protected boolean getOptionValue() {
            return UsageGroupingRuleProviderImpl.this.GROUP_BY_USAGE_TYPE;
        }

        protected void setOptionValue(boolean value) {
            UsageGroupingRuleProviderImpl.this.GROUP_BY_USAGE_TYPE = value;
        }
    }
}

