/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.ImportFilteringRule;
import com.intellij.usages.impl.rules.ReadAccessFilteringRule;
import com.intellij.usages.impl.rules.WriteAccessFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UsageFilteringRuleProviderImpl
implements UsageFilteringRuleProvider,
JDOMExternalizable {
    public boolean SHOW_IMPORTS = true;
    private ReadWriteState myReadWriteState = new ReadWriteState();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public UsageFilteringRule[] getActiveRules(Project project) {
        ArrayList<UsageFilteringRule> rules = new ArrayList<UsageFilteringRule>();
        if (!this.SHOW_IMPORTS) {
            rules.add(new ImportFilteringRule());
        }
        if (!this.myReadWriteState.isShowReadAccess()) {
            rules.add(new ReadAccessFilteringRule());
        }
        if (!this.myReadWriteState.isShowWriteAccess()) {
            rules.add(new WriteAccessFilteringRule());
        }
        UsageFilteringRule[] usageFilteringRuleArray = rules.toArray(new UsageFilteringRule[rules.size()]);
        if (usageFilteringRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.getActiveRules must not return null");
        }
        return usageFilteringRuleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] createFilteringActions(UsageView view) {
        AnAction[] anActionArray;
        UsageViewImpl impl = (UsageViewImpl)view;
        this.myReadWriteState = new ReadWriteState();
        if (view.getPresentation().isCodeUsages()) {
            final JComponent component = view.getComponent();
            final ShowImportsAction showImportsAction = new ShowImportsAction(impl);
            showImportsAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(73, 128)), component);
            final ShowReadAccessUsagesAction showReadAccessUsagesAction = new ShowReadAccessUsagesAction(impl);
            showReadAccessUsagesAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(82, 128)), component);
            final ShowWriteAccessUsagesAction showWriteAccessUsagesAction = new ShowWriteAccessUsagesAction(impl);
            showWriteAccessUsagesAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(87, 128)), component);
            impl.scheduleDisposeOnClose(new Disposable(){

                public void dispose() {
                    showImportsAction.unregisterCustomShortcutSet(component);
                    showReadAccessUsagesAction.unregisterCustomShortcutSet(component);
                    showWriteAccessUsagesAction.unregisterCustomShortcutSet(component);
                }
            });
            anActionArray = new AnAction[]{showImportsAction, showReadAccessUsagesAction, showWriteAccessUsagesAction};
            if (anActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.createFilteringActions must not return null");
            return anActionArray;
        }
        anActionArray = AnAction.EMPTY_ARRAY;
        if (AnAction.EMPTY_ARRAY != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.createFilteringActions must not return null");
    }

    @NotNull
    public String getComponentName() {
        if ("UsageFilteringRuleProvider" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageFilteringRuleProviderImpl.getComponentName must not return null");
        }
        return "UsageFilteringRuleProvider";
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private class ShowWriteAccessUsagesAction
    extends ToggleAction {
        private final UsageViewImpl myView;

        public ShowWriteAccessUsagesAction(UsageViewImpl view) {
            super(UsageViewBundle.message("action.show.write.access", new Object[0]), null, IconLoader.getIcon("/actions/showWriteAccess.png"));
            this.myView = view;
        }

        public boolean isSelected(AnActionEvent e) {
            return UsageFilteringRuleProviderImpl.this.myReadWriteState.isShowWriteAccess();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            UsageFilteringRuleProviderImpl.this.myReadWriteState.setShowWriteAccess(state);
            this.myView.rulesChanged();
        }
    }

    private class ShowReadAccessUsagesAction
    extends ToggleAction {
        private final UsageViewImpl myView;

        public ShowReadAccessUsagesAction(UsageViewImpl view) {
            super(UsageViewBundle.message("action.show.read.access", new Object[0]), null, IconLoader.getIcon("/actions/showReadAccess.png"));
            this.myView = view;
        }

        public boolean isSelected(AnActionEvent e) {
            return UsageFilteringRuleProviderImpl.this.myReadWriteState.isShowReadAccess();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            UsageFilteringRuleProviderImpl.this.myReadWriteState.setShowReadAccess(state);
            this.myView.rulesChanged();
        }
    }

    private static final class ReadWriteState {
        private boolean myShowReadAccess = true;
        private boolean myShowWriteAccess = true;

        private ReadWriteState() {
        }

        public boolean isShowReadAccess() {
            return this.myShowReadAccess;
        }

        public void setShowReadAccess(boolean showReadAccess) {
            this.myShowReadAccess = showReadAccess;
            if (!showReadAccess) {
                this.myShowWriteAccess = true;
            }
        }

        public boolean isShowWriteAccess() {
            return this.myShowWriteAccess;
        }

        public void setShowWriteAccess(boolean showWriteAccess) {
            this.myShowWriteAccess = showWriteAccess;
            if (!showWriteAccess) {
                this.myShowReadAccess = true;
            }
        }
    }

    private class ShowImportsAction
    extends RuleAction {
        public ShowImportsAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.show.import.statements", new Object[0]), IconLoader.getIcon("/actions/showImportStatements.png"));
        }

        protected boolean getOptionValue() {
            return UsageFilteringRuleProviderImpl.this.SHOW_IMPORTS;
        }

        protected void setOptionValue(boolean value) {
            UsageFilteringRuleProviderImpl.this.SHOW_IMPORTS = value;
        }
    }
}

