/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.usages.UsageView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class Node
extends DefaultMutableTreeNode {
    private boolean myIsValid;
    protected final DefaultTreeModel myTreeModel;
    private Boolean myIsReadOnly;
    private boolean myExcluded;
    private String myText;

    protected Node(@NotNull DefaultTreeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/Node.<init> must not be null");
        }
        this.myIsValid = true;
        this.myIsReadOnly = null;
        this.myExcluded = false;
        this.myText = null;
        this.myTreeModel = model;
    }

    public abstract String tree2string(int var1, String var2);

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    protected abstract String getText(UsageView var1);

    public final boolean isValid() {
        return this.myIsValid;
    }

    public final boolean isReadOnly() {
        if (this.myIsReadOnly == null) {
            this.myIsReadOnly = this.isDataReadOnly();
        }
        return this.myIsReadOnly;
    }

    public final boolean isExcluded() {
        return this.myExcluded;
    }

    public final void update(UsageView view) {
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        boolean isExcluded = this.isDataExcluded();
        String text = this.getText(view);
        if (isDataValid != this.myIsValid || this.myIsReadOnly == null || isReadOnly != this.myIsReadOnly || isExcluded != this.myExcluded || !Comparing.equal(this.myText, text)) {
            this.myIsValid = isDataValid;
            this.myExcluded = isExcluded;
            this.myIsReadOnly = isReadOnly;
            this.myText = text;
            this.updateNotify();
            this.myTreeModel.nodeChanged(this);
        }
    }

    protected void updateNotify() {
    }
}

