/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UsageViewManager {
    public static UsageViewManager getInstance(Project project) {
        return ServiceManager.getService(project, UsageViewManager.class);
    }

    @NotNull
    public abstract UsageView createUsageView(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3, Factory<UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3, Factory<UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3);

    @Nullable(value="in case no usages found or usage view not shown for one usage")
    public abstract UsageView searchAndShowUsages(UsageTarget[] var1, Factory<UsageSearcher> var2, boolean var3, boolean var4, UsageViewPresentation var5, UsageViewStateListener var6);

    public abstract void setCurrentSearchCancelled(boolean var1);

    public abstract boolean searchHasBeenCancelled();

    public abstract void searchAndShowUsages(UsageTarget[] var1, Factory<UsageSearcher> var2, FindUsagesProcessPresentation var3, UsageViewPresentation var4, UsageViewStateListener var5);

    @Nullable
    public abstract UsageView getSelectedUsageView();

    public static interface UsageViewStateListener {
        public void usageViewCreated(UsageView var1);

        public void findingUsagesFinished(UsageView var1);
    }
}

