/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UsageModelTracker {
    private PsiTreeChangeListener myPsiListener;
    private Project myProject;
    private List<UsageModelTrackerListener> myListeners = new CopyOnWriteArrayList<UsageModelTrackerListener>();

    public UsageModelTracker(Project project) {
        this.myProject = project;
        this.myPsiListener = new PsiTreeChangeAdapter(){

            public void childAdded(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            public void childrenChanged(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            public void childMoved(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            public void propertyChanged(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, true);
            }
        };
        PsiManager.getInstance(project).addPsiTreeChangeListener(this.myPsiListener);
    }

    private void doFire(PsiTreeChangeEvent event, boolean propertyChange) {
        if (!(event.getFile() instanceof PsiCodeFragment)) {
            this.fireModelChanged(propertyChange);
        }
    }

    public void dispose() {
        PsiManager.getInstance(this.myProject).removePsiTreeChangeListener(this.myPsiListener);
    }

    public void addListener(UsageModelTrackerListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(UsageModelTrackerListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireModelChanged(boolean isPropertyChange) {
        for (UsageModelTrackerListener listener : this.myListeners) {
            listener.modelChanged(isPropertyChange);
        }
    }

    public static interface UsageModelTrackerListener {
        public void modelChanged(boolean var1);
    }
}

