/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageConvertor;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageInfoToUsageConverter {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Usage convert(TargetElementsDescriptor descriptor, UsageInfo usageInfo) {
        UsageConvertor[] convertors;
        Usage usage = UsageInfoToUsageConverter._convert(descriptor, usageInfo);
        for (UsageConvertor convertor : convertors = ApplicationManager.getApplication().getComponents(UsageConvertor.class)) {
            usage = convertor.convert(usage);
        }
        Usage usage2 = usage;
        if (usage2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter.convert must not return null");
        }
        return usage2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Usage _convert(TargetElementsDescriptor descriptor, UsageInfo usageInfo) {
        UsageInfo2UsageAdapter usageInfo2UsageAdapter;
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        if (UsageInfoToUsageConverter.isReadWriteAccessibleElements(primaryElements)) {
            PsiElement usageElement = usageInfo.getElement();
            if (usageElement instanceof PsiReferenceExpression) {
                Access access = UsageInfoToUsageConverter.isAccessedForReading((PsiReferenceExpression)usageElement);
                usageInfo2UsageAdapter = new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, access.read, access.write);
                if (usageInfo2UsageAdapter == null) throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter._convert must not return null");
                return usageInfo2UsageAdapter;
            }
            if (usageElement instanceof XmlAttributeValue) {
                Access access = new Access(false, true);
                usageInfo2UsageAdapter = new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, access.read, access.write);
                if (usageInfo2UsageAdapter == null) throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter._convert must not return null");
                return usageInfo2UsageAdapter;
            }
        }
        if ((usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo)) != null) return usageInfo2UsageAdapter;
        throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter._convert must not return null");
    }

    public static Usage[] convert(TargetElementsDescriptor descriptor, UsageInfo[] usageInfos) {
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        return usages;
    }

    private static boolean isReadWriteAccessibleElements(PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiVariable || element instanceof XmlAttributeValue) continue;
            return false;
        }
        return true;
    }

    private static Access isAccessedForReading(PsiReferenceExpression referent) {
        PsiElement actualReferee;
        boolean accessedForReading = PsiUtil.isAccessedForReading(referent);
        boolean accessedForWriting = PsiUtil.isAccessedForWriting(referent);
        if (!accessedForWriting && (actualReferee = referent.resolve()) instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)actualReferee)) {
            accessedForWriting = true;
            accessedForReading = false;
        }
        return new Access(accessedForReading, accessedForWriting);
    }

    private static final class Access {
        public final boolean read;
        public final boolean write;

        public Access(boolean read, boolean write) {
            this.read = read;
            this.write = write;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer> myAdditionalSearchedElements;
        private static final Function<SmartPsiElementPointer, PsiElement> SMARTPOINTER_TO_ELEMENT_MAPPER = new Function<SmartPsiElementPointer, PsiElement>(){

            @Override
            public PsiElement fun(SmartPsiElementPointer s) {
                return s.getElement();
            }
        };

        public TargetElementsDescriptor(PsiElement element) {
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements) {
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements, PsiElement[] additionalSearchedElements) {
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        private static PsiElement[] convertToPsiElements(List<SmartPsiElementPointer> primary) {
            return ContainerUtil.map2Array(primary, PsiElement.class, SMARTPOINTER_TO_ELEMENT_MAPPER);
        }

        private static List<SmartPsiElementPointer> convertToSmartPointers(PsiElement[] primaryElements) {
            return primaryElements != null ? ContainerUtil.mapNotNull(primaryElements, new Function<PsiElement, SmartPsiElementPointer>(){

                @Override
                public SmartPsiElementPointer fun(PsiElement s) {
                    return SmartPointerManager.getInstance(s.getProject()).createSmartPsiElementPointer(s);
                }
            }) : Collections.emptyList();
        }

        public PsiElement[] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        public PsiElement[] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        public List<? extends PsiElement> getAllElements() {
            Object element;
            ArrayList result = new ArrayList(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            return result;
        }
    }
}

