/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.RenameableUsage;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageInfo2UsageAdapter
implements UsageInModule,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage,
Comparable<UsageInfo2UsageAdapter>,
RenameableUsage,
TypeSafeDataProvider {
    private static final Logger LOG = Logger.getInstance("#com.intellij.usages.UsageInfo2UsageAdapter");
    private final UsageInfo myUsageInfo;
    private int myLineNumber;
    protected Icon myIcon;
    private String myTooltipText;
    private List<RangeMarker> myRangeMarkers = new ArrayList<RangeMarker>();
    private TextChunk[] myTextChunks;
    private final UsagePresentation myUsagePresentation;
    private String myPlainText;

    public UsageInfo2UsageAdapter(UsageInfo usageInfo) {
        this.myUsageInfo = usageInfo;
        this.myUsagePresentation = ApplicationManager.getApplication().runReadAction(new Computable<UsagePresentation>(){

            @Override
            public UsagePresentation compute() {
                PsiElement element = UsageInfo2UsageAdapter.this.getElement();
                PsiFile psiFile = element.getContainingFile();
                Document document = PsiDocumentManager.getInstance(element.getProject()).getDocument(psiFile);
                TextRange range = element.getTextRange();
                int startOffset = range.getStartOffset() + ((UsageInfo2UsageAdapter)UsageInfo2UsageAdapter.this).myUsageInfo.startOffset;
                int endOffset = range.getStartOffset() + ((UsageInfo2UsageAdapter)UsageInfo2UsageAdapter.this).myUsageInfo.endOffset;
                UsageInfo2UsageAdapter.this.myLineNumber = UsageInfo2UsageAdapter.getLineNumber(document, startOffset);
                if (endOffset > document.getTextLength()) {
                    LOG.assertTrue(false, "Invalid usage info, psiElement:" + element + " end offset: " + endOffset + " psiFile: " + psiFile.getName());
                }
                UsageInfo2UsageAdapter.this.myRangeMarkers.add(document.createRangeMarker(startOffset, endOffset));
                UsageInfo2UsageAdapter.this.myIcon = element instanceof PsiFile ? null : element.getIcon(0);
                UsageInfo2UsageAdapter.this.myTooltipText = UsageInfo2UsageAdapter.this.myUsageInfo.getTooltipText();
                UsageInfo2UsageAdapter.this.initChunks();
                return new MyUsagePresentation();
            }
        });
    }

    private static int getLineNumber(Document document, int startOffset) {
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (startOffset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(startOffset);
    }

    private void initChunks() {
        this.myTextChunks = new ChunkExtractor(this.getElement(), this.myRangeMarkers).extractChunks();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public UsagePresentation getPresentation() {
        UsagePresentation usagePresentation = this.myUsagePresentation;
        if (usagePresentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfo2UsageAdapter.getPresentation must not return null");
        }
        return usagePresentation;
    }

    @Override
    public boolean isValid() {
        if (this.getElement() == null) {
            return false;
        }
        for (RangeMarker rangeMarker : this.myRangeMarkers) {
            if (rangeMarker.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.isValid() && !this.getElement().isWritable();
    }

    @Override
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance(this.getProject()).getSelectedEditor(virtualFile);
        if (editor == null) {
            return null;
        }
        return new TextEditorLocation(this.myUsageInfo.startOffset + this.getElement().getTextRange().getStartOffset(), (TextEditor)editor);
    }

    @Override
    public void selectInEditor() {
        if (!this.isValid()) {
            return;
        }
        Editor editor = this.openTextEditor(false);
        RangeMarker marker = this.getRangeMarker();
        editor.getSelectionModel().setSelection(marker.getStartOffset(), marker.getEndOffset());
    }

    @Override
    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        RangeMarker marker = this.getRangeMarker();
        SelectInEditorManager.getInstance(this.getProject()).selectInEditor(this.getFile(), marker.getStartOffset(), marker.getEndOffset(), false, false);
    }

    public final RangeMarker getRangeMarker() {
        return this.myRangeMarkers.get(0);
    }

    public List<RangeMarker> getRangeMarkers() {
        return this.myRangeMarkers;
    }

    @Override
    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            this.openTextEditor(focus);
        }
    }

    public Editor openTextEditor(boolean focus) {
        return FileEditorManager.getInstance(this.getProject()).openTextEditor(this.getDescriptor(), focus);
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private OpenFileDescriptor getDescriptor() {
        return this.isValid() ? new OpenFileDescriptor(this.getProject(), this.getFile(), this.getRangeMarker().getStartOffset()) : null;
    }

    private Project getProject() {
        return this.getElement().getProject();
    }

    public String toString() {
        TextChunk[] textChunks = this.getPresentation().getText();
        StringBuilder result = new StringBuilder();
        for (int j = 0; j < textChunks.length; ++j) {
            if (j > 0) {
                result.append("|");
            }
            TextChunk textChunk = textChunks[j];
            result.append(textChunk);
        }
        return result.toString();
    }

    @Override
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement element = this.getElement();
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(element.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        return fileIndex.getModuleForFile(virtualFile);
    }

    @Override
    public OrderEntry getLibraryEntry() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement element = this.getElement();
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(element.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        if (psiFile instanceof PsiCompiledElement || fileIndex.isInLibrarySource(virtualFile)) {
            List<OrderEntry> orders = fileIndex.getOrderEntriesForFile(psiFile.getVirtualFile());
            for (OrderEntry order : orders) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return order;
            }
        }
        return null;
    }

    @Override
    public VirtualFile getFile() {
        return this.isValid() ? this.getElement().getContainingFile().getVirtualFile() : null;
    }

    public int getLine() {
        return this.myLineNumber;
    }

    @Override
    public boolean merge(MergeableUsage other) {
        if (!(other instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo2UsageAdapter u2 = (UsageInfo2UsageAdapter)other;
        if (this.myLineNumber != u2.myLineNumber || this.getFile() != u2.getFile()) {
            return false;
        }
        this.myRangeMarkers.addAll(u2.myRangeMarkers);
        this.initChunks();
        return true;
    }

    @Override
    public void reset() {
        if (this.myRangeMarkers.size() > 1) {
            RangeMarker marker = this.getRangeMarker();
            this.myRangeMarkers = new ArrayList<RangeMarker>();
            this.myRangeMarkers.add(marker);
            this.initChunks();
        }
    }

    @Override
    public final PsiElement getElement() {
        return this.myUsageInfo.getElement();
    }

    public PsiReference getReference() {
        return this.getElement().getReference();
    }

    @Override
    public boolean isNonCodeUsage() {
        return this.myUsageInfo.isNonCodeUsage;
    }

    public UsageInfo getUsageInfo() {
        return this.myUsageInfo;
    }

    @Override
    public int compareTo(UsageInfo2UsageAdapter o) {
        PsiFile oContainingFile;
        PsiElement element = this.getElement();
        PsiFile containingFile = element == null ? null : element.getContainingFile();
        PsiElement oElement = o.getElement();
        PsiFile psiFile = oContainingFile = oElement == null ? null : oElement.getContainingFile();
        if (containingFile == null && oContainingFile == null || !Comparing.equal(containingFile, oContainingFile)) {
            return 0;
        }
        return this.getRangeMarker().getStartOffset() - o.getRangeMarker().getStartOffset();
    }

    @Override
    public void rename(String newName) throws IncorrectOperationException {
        PsiReference reference = this.myUsageInfo.getReference();
        assert (reference != null) : this;
        reference.handleElementRename(newName);
    }

    public static UsageInfo2UsageAdapter[] convert(UsageInfo[] usageInfos) {
        UsageInfo2UsageAdapter[] result = new UsageInfo2UsageAdapter[usageInfos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new UsageInfo2UsageAdapter(usageInfos[i]);
        }
        return result;
    }

    @Override
    public void calcData(DataKey key, DataSink sink) {
        if (key == UsageView.USAGE_INFO_KEY) {
            sink.put(UsageView.USAGE_INFO_KEY, this.getUsageInfo());
        }
        if (key == UsageView.USAGE_INFO_LIST_KEY) {
            ArrayList<UsageInfo> list = this.getSelectedInfoList();
            sink.put(UsageView.USAGE_INFO_LIST_KEY, list);
        }
    }

    private ArrayList<UsageInfo> getSelectedInfoList() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        UsageInfo first = this.getUsageInfo();
        list.add(first);
        for (int i = 1; i < this.myRangeMarkers.size(); ++i) {
            RangeMarker rangeMarker = this.myRangeMarkers.get(i);
            PsiElement element = first.getElement();
            if (element == null) continue;
            PsiFile file = element.getContainingFile();
            UsageInfo usageInfo = new UsageInfo(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
            list.add(usageInfo);
        }
        return list;
    }

    private class MyUsagePresentation
    implements UsagePresentation {
        private long myModificationStamp = this.getCurrentModificationStamp();

        private long getCurrentModificationStamp() {
            PsiFile containingFile = UsageInfo2UsageAdapter.this.getElement().getContainingFile();
            return containingFile == null ? -1L : containingFile.getModificationStamp();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public TextChunk[] getText() {
            long currentModificationStamp;
            if (UsageInfo2UsageAdapter.this.isValid() && (currentModificationStamp = this.getCurrentModificationStamp()) != this.myModificationStamp) {
                UsageInfo2UsageAdapter.this.initChunks();
                this.myModificationStamp = currentModificationStamp;
            }
            TextChunk[] textChunkArray = UsageInfo2UsageAdapter.this.myTextChunks;
            if (textChunkArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfo2UsageAdapter$MyUsagePresentation.getText must not return null");
            }
            return textChunkArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public String getPlainText() {
            int startOffset = ChunkExtractor.getStartOffset(UsageInfo2UsageAdapter.this.myRangeMarkers);
            PsiElement element = UsageInfo2UsageAdapter.this.getElement();
            if (element == null) return "";
            Document document = PsiDocumentManager.getInstance(element.getProject()).getDocument(element.getContainingFile());
            if (document == null) return "";
            int lineNumber = document.getLineNumber(startOffset);
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String string = ((Object)document.getCharsSequence().subSequence(lineStart, lineEnd)).toString();
            String string2 = string;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfo2UsageAdapter$MyUsagePresentation.getPlainText must not return null");
            return string2;
        }

        public Icon getIcon() {
            return UsageInfo2UsageAdapter.this.myIcon;
        }

        public String getTooltipText() {
            return UsageInfo2UsageAdapter.this.myTooltipText;
        }
    }
}

